/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.hosted.plugin;

import ai.vespa.hosted.api.Deployment;
import ai.vespa.hosted.api.DeploymentLog;
import ai.vespa.hosted.api.DeploymentResult;
import ai.vespa.hosted.plugin.AbstractVespaDeploymentMojo;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.zone.ZoneId;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="deploy")
public class DeployMojo
extends AbstractVespaDeploymentMojo {
    @Parameter(property="applicationZip")
    private String applicationZip;
    @Parameter(property="vespaVersion")
    private String vespaVersion;
    @Parameter(property="follow", defaultValue="true")
    private boolean follow;
    @Parameter(property="vespaLogLevel", defaultValue="error")
    private String vespaLogLevel;
    private DeploymentLog.Level loggable;
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss").withZone(ZoneOffset.UTC);
    private static final String padding = "\n" + " ".repeat(23);

    @Override
    protected boolean requireInstance() {
        return true;
    }

    @Override
    protected void doExecute() throws MojoFailureException, MojoExecutionException {
        this.loggable = DeploymentLog.Level.valueOf((String)this.vespaLogLevel);
        Deployment deployment = Deployment.ofPackage((Path)Paths.get(DeployMojo.firstNonBlank(this.applicationZip, this.projectPathOf("target", "application.zip")).orElseThrow(), new String[0]));
        if (!DeployMojo.isNullOrBlank(this.vespaVersion)) {
            deployment = deployment.atVersion(this.vespaVersion);
        }
        ZoneId zone = this.zoneOf(this.environment, this.region);
        DeploymentResult result = this.controller.deploy(deployment, this.id, zone);
        this.getLog().info((CharSequence)result.message());
        if (this.follow) {
            this.tailLogs(this.id, zone, result.run());
        }
    }

    private void tailLogs(ApplicationId id, ZoneId zone, long run) throws MojoFailureException, MojoExecutionException {
        DeploymentLog log = this.controller.followDeploymentUntilDone(id, zone, run, this::print);
        switch (log.status()) {
            case success: {
                return;
            }
            case error: {
                throw new MojoExecutionException("Unexpected error during deployment; see log for details");
            }
            case aborted: {
                throw new MojoFailureException("Deployment was aborted, probably by a newer deployment");
            }
            case nodeAllocationFailure: {
                throw new MojoFailureException("Specified node capacity could not be fulfilled for your tenant; contact Vespa Cloud support");
            }
            case deploymentFailed: {
                throw new MojoFailureException("Deployment failed; see log for details");
            }
            case installationFailed: {
                throw new MojoFailureException("Installation failed; see Vespa log for details");
            }
            case running: {
                throw new MojoFailureException("Deployment not completed");
            }
            case endpointCertificateTimeout: {
                throw new MojoFailureException("Endpoint certificate not ready in time; please contact Vespa team");
            }
            case testFailure: {
                throw new IllegalStateException("Unexpected status; tests are not run for manual deployments");
            }
        }
        throw new IllegalArgumentException("Unexpected status '" + log.status() + "'");
    }

    private void print(DeploymentLog.Entry entry) {
        String timestamp = formatter.format(entry.at());
        String message = String.join((CharSequence)padding, entry.message().split("\n")).replaceAll("\\s*\n", "\n").trim();
        if (!entry.isVespaLogEntry() || this.loggable.compareTo((Enum)entry.level()) >= 0) {
            switch (entry.level()) {
                case error: {
                    this.getLog().error((CharSequence)("   [" + timestamp + "]  " + message));
                    break;
                }
                case warning: {
                    this.getLog().warn((CharSequence)(" [" + timestamp + "]  " + message));
                    break;
                }
                case info: {
                    this.getLog().info((CharSequence)("    [" + timestamp + "]  " + message));
                    break;
                }
                default: {
                    this.getLog().debug((CharSequence)("   [" + timestamp + "]  " + message));
                }
            }
        }
    }
}

