/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.hosted.plugin;

import ai.vespa.hosted.api.Submission;
import ai.vespa.hosted.plugin.AbstractVespaMojo;
import java.nio.file.Paths;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="submit")
public class SubmitMojo
extends AbstractVespaMojo {
    @Parameter(property="applicationZip")
    private String applicationZip;
    @Parameter(property="applicationTestZip")
    private String applicationTestZip;
    @Parameter(property="authorEmail")
    private String authorEmail;
    @Parameter(property="repository")
    private String repository;
    @Parameter(property="branch")
    private String branch;
    @Parameter(property="commit")
    private String commit;
    @Parameter(property="sourceUrl")
    private String sourceUrl;
    @Parameter(property="projectId")
    private String projectId;
    @Parameter(property="risk")
    private String risk;
    @Parameter(property="description")
    private String description;

    @Override
    public void doExecute() {
        this.applicationZip = SubmitMojo.firstNonBlank(this.applicationZip, this.projectPathOf("target", "application.zip")).orElseThrow();
        this.applicationTestZip = SubmitMojo.firstNonBlank(this.applicationTestZip, this.projectPathOf("target", "application-test.zip")).orElseThrow();
        Submission submission = new Submission(SubmitMojo.optionalOf(this.repository), SubmitMojo.optionalOf(this.branch), SubmitMojo.optionalOf(this.commit), SubmitMojo.optionalOf(this.sourceUrl), SubmitMojo.optionalOf(this.authorEmail), Paths.get(this.applicationZip, new String[0]), Paths.get(this.applicationTestZip, new String[0]), SubmitMojo.optionalOf(this.projectId, Long::parseLong), SubmitMojo.optionalOf(this.risk, Integer::parseInt), SubmitMojo.optionalOf(this.description));
        this.getLog().info((CharSequence)this.controller.submit(submission, this.id.tenant(), this.id.application()));
    }
}

