/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.hosted.plugin;

import ai.vespa.hosted.plugin.AbstractVespaDeploymentMojo;
import com.yahoo.config.application.XmlPreProcessor;
import com.yahoo.config.provision.InstanceName;
import com.yahoo.config.provision.zone.ZoneId;
import java.io.File;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.w3c.dom.Document;

@Mojo(name="effectiveServices")
public class EffectiveServicesMojo
extends AbstractVespaDeploymentMojo {
    @Parameter(property="servicesFile", defaultValue="src/main/application/services.xml")
    private String servicesFile;
    @Parameter(property="outputDirectory", defaultValue="target")
    private String outputDirectory;

    @Override
    protected void doExecute() throws Exception {
        File services = new File(this.servicesFile);
        if (!services.isFile()) {
            throw new IllegalArgumentException(this.servicesFile + " does not exist. Set correct path with -DservicesFile=<path to services.xml>");
        }
        ZoneId zone = this.zoneOf(this.environment, this.region);
        Path output = Paths.get(this.outputDirectory, new String[0]).resolve("services-" + zone.environment().value() + "-" + zone.region().value() + ".xml");
        Files.write(output, EffectiveServicesMojo.effectiveServices(services, zone, InstanceName.from((String)this.instance)).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        this.getLog().info((CharSequence)("Effective services for " + zone + " written to " + output));
    }

    static String effectiveServices(File servicesFile, ZoneId zone, InstanceName instance) throws Exception {
        Document processedServicesXml = new XmlPreProcessor(servicesFile.getParentFile(), servicesFile, instance, zone.environment(), zone.region()).run();
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(processedServicesXml), new StreamResult(writer));
        return ((Object)writer).toString().replaceAll("\n(\\s*\n)+", "\n");
    }
}

