/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.hosted.plugin;

import ai.vespa.hosted.api.ControllerHttpClient;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.InstanceName;
import com.yahoo.yolean.Exceptions;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractVespaMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(property="endpoint", defaultValue="https://api.vespa-external.aws.oath.cloud:4443")
    protected String endpoint;
    @Parameter(property="tenant")
    protected String tenant;
    @Parameter(property="application")
    protected String application;
    @Parameter(property="instance")
    protected String instance;
    @Parameter(property="apiKey")
    protected String apiKey;
    @Parameter(property="apiKeyFile")
    protected String apiKeyFile;
    @Parameter(property="apiCertificateFile")
    protected String apiCertificateFile;
    protected ApplicationId id;
    protected ControllerHttpClient controller;

    protected boolean requireInstance() {
        return false;
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.setup();
            this.doExecute();
        }
        catch (MojoExecutionException | MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            String message = "Execution failed for application " + this.name() + ":\n" + Exceptions.toMessageString((Throwable)e);
            if (e.getSuppressed().length > 0) {
                message = message + "\nSuppressed:\n" + Stream.of(e.getSuppressed()).map(Exceptions::toMessageString).collect(Collectors.joining("\n"));
            }
            throw new MojoExecutionException(message, e);
        }
    }

    protected abstract void doExecute() throws Exception;

    protected String name() {
        return this.tenant + "." + this.application;
    }

    protected void setup() throws MojoExecutionException {
        this.tenant = AbstractVespaMojo.firstNonBlank(this.tenant, this.project.getProperties().getProperty("tenant")).orElseThrow(() -> new MojoExecutionException("'tenant' must be specified as a parameter or project property"));
        this.application = AbstractVespaMojo.firstNonBlank(this.application, this.project.getProperties().getProperty("application")).orElseThrow(() -> new MojoExecutionException("'application' must be specified as a parameter or project property"));
        this.instance = AbstractVespaMojo.firstNonBlank(this.instance, this.project.getProperties().getProperty("instance"), this.requireInstance() ? null : InstanceName.defaultName().value()).orElseThrow(() -> new MojoExecutionException("'instance' must be specified as a parameter or project property"));
        this.id = ApplicationId.from((String)this.tenant, (String)this.application, (String)this.instance);
        Optional<Path> apiKeyPath = this.apiKeyPath(this.tenant);
        if (!AbstractVespaMojo.isNullOrBlank(this.apiKey)) {
            this.controller = ControllerHttpClient.withSignatureKey((URI)URI.create(this.endpoint), (String)this.apiKey, (ApplicationId)this.id);
        } else if (apiKeyPath.isPresent()) {
            this.controller = AbstractVespaMojo.isNullOrBlank(this.apiCertificateFile) ? ControllerHttpClient.withSignatureKey((URI)URI.create(this.endpoint), (Path)apiKeyPath.get(), (ApplicationId)this.id) : ControllerHttpClient.withKeyAndCertificate((URI)URI.create(this.endpoint), (Path)apiKeyPath.get(), (Path)Paths.get(this.apiCertificateFile, new String[0]));
        } else {
            throw new IllegalArgumentException("One of the properties 'apiKey' or 'apiKeyFile' is required.");
        }
    }

    private Optional<Path> apiKeyPath(String tenant) {
        if (!AbstractVespaMojo.isNullOrBlank(this.apiKeyFile)) {
            return Optional.of(Paths.get(this.apiKeyFile, new String[0]));
        }
        Path cliApiKeyFile = Optional.ofNullable(System.getenv("VESPA_CLI_HOME")).map(x$0 -> Paths.get(x$0, new String[0])).orElseGet(() -> Paths.get(System.getProperty("user.home"), ".vespa")).resolve(tenant + ".api-key.pem");
        if (Files.exists(cliApiKeyFile, new LinkOption[0])) {
            return Optional.of(cliApiKeyFile);
        }
        return Optional.empty();
    }

    protected String projectPathOf(String first, String ... rest) {
        return this.project.getBasedir().toPath().resolve(Path.of(first, rest)).toString();
    }

    protected static Optional<String> firstNonBlank(String ... values) {
        for (String value : values) {
            if (value == null || value.isBlank()) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }

    protected static Optional<String> optionalOf(String value) {
        return Optional.ofNullable(value).filter(data -> !data.isBlank());
    }

    protected static <T> Optional<T> optionalOf(String value, Function<String, T> mapper) {
        return Optional.ofNullable(value).filter(data -> !data.isBlank()).map(mapper);
    }

    protected static boolean isNullOrBlank(String value) {
        return Optional.ofNullable(value).filter(s -> !s.isBlank()).isEmpty();
    }
}

