/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.feed.client.impl;

import ai.vespa.feed.client.DocumentId;
import ai.vespa.feed.client.FeedClient;
import ai.vespa.feed.client.FeedException;
import ai.vespa.feed.client.HttpResponse;
import ai.vespa.feed.client.OperationParameters;
import ai.vespa.feed.client.OperationStats;
import ai.vespa.feed.client.Result;
import ai.vespa.feed.client.ResultException;
import ai.vespa.feed.client.ResultParseException;
import ai.vespa.feed.client.impl.FeedClientBuilderImpl;
import ai.vespa.feed.client.impl.HttpRequest;
import ai.vespa.feed.client.impl.HttpRequestStrategy;
import ai.vespa.feed.client.impl.RequestStrategy;
import ai.vespa.feed.client.impl.ResultImpl;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;

class HttpFeedClient
implements FeedClient {
    private static final JsonFactory factory = new JsonFactory();
    private final Map<String, Supplier<String>> requestHeaders;
    private final RequestStrategy requestStrategy;
    private final AtomicBoolean closed = new AtomicBoolean();

    HttpFeedClient(FeedClientBuilderImpl builder) throws IOException {
        this(builder, new HttpRequestStrategy(builder));
    }

    HttpFeedClient(FeedClientBuilderImpl builder, RequestStrategy requestStrategy) {
        this.requestHeaders = new HashMap<String, Supplier<String>>(builder.requestHeaders);
        this.requestStrategy = requestStrategy;
    }

    public CompletableFuture<Result> put(DocumentId documentId, String documentJson, OperationParameters params) {
        return this.send("POST", documentId, Objects.requireNonNull(documentJson), params);
    }

    public CompletableFuture<Result> update(DocumentId documentId, String updateJson, OperationParameters params) {
        return this.send("PUT", documentId, Objects.requireNonNull(updateJson), params);
    }

    public CompletableFuture<Result> remove(DocumentId documentId, OperationParameters params) {
        return this.send("DELETE", documentId, null, params);
    }

    public OperationStats stats() {
        return this.requestStrategy.stats();
    }

    public FeedClient.CircuitBreaker.State circuitBreakerState() {
        return this.requestStrategy.circuitBreakerState();
    }

    public void close(boolean graceful) {
        this.closed.set(true);
        if (graceful) {
            this.requestStrategy.await();
        }
        this.requestStrategy.destroy();
    }

    private CompletableFuture<Result> send(String method, DocumentId documentId, String operationJson, OperationParameters params) {
        if (this.closed.get()) {
            throw new IllegalStateException("Client is closed");
        }
        HttpRequest request = new HttpRequest(method, HttpFeedClient.getPath(documentId) + HttpFeedClient.getQuery(params), this.requestHeaders, operationJson == null ? null : operationJson.getBytes(StandardCharsets.UTF_8), params.timeout().orElse(null));
        CompletableFuture<Result> promise = new CompletableFuture<Result>();
        ((CompletableFuture)this.requestStrategy.enqueue(documentId, request).thenApply(response -> HttpFeedClient.toResult(request, response, documentId))).whenComplete((result, thrown) -> {
            if (thrown != null) {
                while (thrown instanceof CompletionException) {
                    thrown = thrown.getCause();
                }
                promise.completeExceptionally((Throwable)thrown);
            } else {
                promise.complete((Result)result);
            }
        });
        return promise;
    }

    static Result.Type toResultType(Outcome outcome) {
        switch (outcome) {
            case success: {
                return Result.Type.success;
            }
            case conditionNotMet: {
                return Result.Type.conditionNotMet;
            }
        }
        throw new IllegalArgumentException("No corresponding result type for '" + (Object)((Object)outcome) + "'");
    }

    static Result toResult(HttpRequest request, HttpResponse response, DocumentId documentId) {
        Outcome outcome;
        switch (response.code()) {
            case 200: {
                outcome = Outcome.success;
                break;
            }
            case 412: {
                outcome = Outcome.conditionNotMet;
                break;
            }
            case 502: 
            case 504: 
            case 507: {
                outcome = Outcome.vespaFailure;
                break;
            }
            default: {
                outcome = Outcome.transportFailure;
            }
        }
        String message = null;
        String trace = null;
        try {
            String name;
            JsonParser parser = factory.createParser(response.body());
            if (parser.nextToken() != JsonToken.START_OBJECT) {
                throw new ResultParseException(documentId, "Expected '" + JsonToken.START_OBJECT + "', but found '" + parser.currentToken() + "' in: " + new String(response.body(), StandardCharsets.UTF_8));
            }
            block19: while ((name = parser.nextFieldName()) != null) {
                switch (name) {
                    case "message": {
                        message = parser.nextTextValue();
                        continue block19;
                    }
                    case "trace": {
                        if (parser.nextToken() != JsonToken.START_ARRAY) {
                            throw new ResultParseException(documentId, "Expected 'trace' to be an array, but got '" + parser.currentToken() + "' in: " + new String(response.body(), StandardCharsets.UTF_8));
                        }
                        int start = (int)parser.getTokenLocation().getByteOffset();
                        int depth = 1;
                        while (depth > 0) {
                            switch (parser.nextToken()) {
                                case START_ARRAY: {
                                    ++depth;
                                    break;
                                }
                                case END_ARRAY: {
                                    --depth;
                                }
                            }
                        }
                        int end = (int)parser.getTokenLocation().getByteOffset() + 1;
                        trace = new String(response.body(), start, end - start, StandardCharsets.UTF_8);
                        continue block19;
                    }
                }
                parser.nextToken();
            }
            if (parser.currentToken() != JsonToken.END_OBJECT) {
                throw new ResultParseException(documentId, "Expected '" + JsonToken.END_OBJECT + "', but found '" + parser.currentToken() + "' in: " + new String(response.body(), StandardCharsets.UTF_8));
            }
        }
        catch (IOException e) {
            throw new ResultParseException(documentId, (Throwable)e);
        }
        if (outcome == Outcome.transportFailure) {
            throw new FeedException(documentId, "Status " + response.code() + " executing '" + request + "': " + (message == null ? new String(response.body(), StandardCharsets.UTF_8) : message));
        }
        if (outcome == Outcome.vespaFailure) {
            throw new ResultException(documentId, message, trace);
        }
        return new ResultImpl(HttpFeedClient.toResultType(outcome), documentId, message, trace);
    }

    static String getPath(DocumentId documentId) {
        StringJoiner path = new StringJoiner("/", "/", "");
        path.add("document");
        path.add("v1");
        path.add(HttpFeedClient.encode(documentId.namespace()));
        path.add(HttpFeedClient.encode(documentId.documentType()));
        if (documentId.number().isPresent()) {
            path.add("number");
            path.add(Long.toUnsignedString(documentId.number().getAsLong()));
        } else if (documentId.group().isPresent()) {
            path.add("group");
            path.add(HttpFeedClient.encode((String)documentId.group().get()));
        } else {
            path.add("docid");
        }
        path.add(HttpFeedClient.encode(documentId.userSpecific()));
        return path.toString();
    }

    static String encode(String raw) {
        try {
            return URLEncoder.encode(raw, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    static String getQuery(OperationParameters params) {
        StringJoiner query = new StringJoiner("&", "?", "").setEmptyValue("");
        if (params.createIfNonExistent()) {
            query.add("create=true");
        }
        params.testAndSetCondition().ifPresent(condition -> query.add("condition=" + HttpFeedClient.encode(condition)));
        params.timeout().ifPresent(timeout -> query.add("timeout=" + timeout.toMillis() + "ms"));
        params.route().ifPresent(route -> query.add("route=" + HttpFeedClient.encode(route)));
        params.tracelevel().ifPresent(tracelevel -> query.add("tracelevel=" + tracelevel));
        return query.toString();
    }

    private static enum Outcome {
        success,
        conditionNotMet,
        vespaFailure,
        transportFailure;

    }
}

