/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.feed.client.impl;

import ai.vespa.feed.client.HttpResponse;
import ai.vespa.feed.client.impl.Cluster;
import ai.vespa.feed.client.impl.FeedClientBuilderImpl;
import ai.vespa.feed.client.impl.HttpRequest;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.client5.http.ssl.ClientTlsStrategyBuilder;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.http.ssl.TlsCiphers;
import org.apache.hc.core5.http2.config.H2Config;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.apache.hc.core5.util.Timeout;

class ApacheCluster
implements Cluster {
    private final List<Endpoint> endpoints = new ArrayList<Endpoint>();
    private final List<BasicHeader> defaultHeaders = Arrays.asList(new BasicHeader("User-Agent", (Object)String.format("vespa-feed-client/%s", "7.164.0")), new BasicHeader("Vespa-Client-Version", (Object)"7.164.0"));
    private final RequestConfig requestConfig;
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(t -> new Thread(t, "request-timeout-thread"));

    ApacheCluster(FeedClientBuilderImpl builder) throws IOException {
        for (URI endpoint : builder.endpoints) {
            for (int i = 0; i < builder.connectionsPerEndpoint; ++i) {
                this.endpoints.add(new Endpoint(ApacheCluster.createHttpClient(builder), endpoint));
            }
        }
        this.requestConfig = ApacheCluster.createRequestConfig(builder);
    }

    @Override
    public void dispatch(HttpRequest wrapped, final CompletableFuture<HttpResponse> vessel) {
        int index = 0;
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < this.endpoints.size(); ++i) {
            if (this.endpoints.get(i).inflight.get() >= min) continue;
            index = i;
            min = this.endpoints.get(i).inflight.get();
        }
        Endpoint endpoint = this.endpoints.get(index);
        endpoint.inflight.incrementAndGet();
        try {
            SimpleHttpRequest request = new SimpleHttpRequest(wrapped.method(), wrapped.path());
            request.setScheme(endpoint.url.getScheme());
            request.setAuthority(new URIAuthority(endpoint.url.getHost(), ApacheCluster.portOf(endpoint.url)));
            request.setConfig(this.requestConfig);
            this.defaultHeaders.forEach(arg_0 -> ((SimpleHttpRequest)request).setHeader(arg_0));
            wrapped.headers().forEach((name, value) -> request.setHeader(name, value.get()));
            if (wrapped.body() != null) {
                request.setBody(wrapped.body(), ContentType.APPLICATION_JSON);
            }
            Future future = endpoint.client.execute(request, (FutureCallback)new FutureCallback<SimpleHttpResponse>(){

                public void completed(SimpleHttpResponse response) {
                    vessel.complete(new ApacheHttpResponse(response));
                }

                public void failed(Exception ex) {
                    vessel.completeExceptionally(ex);
                }

                public void cancelled() {
                    vessel.cancel(false);
                }
            });
            long timeoutMillis = wrapped.timeout() == null ? 200000L : wrapped.timeout().toMillis() * 11L / 10L + 1000L;
            ScheduledFuture<?> cancellation = this.executor.schedule(() -> {
                future.cancel(true);
                vessel.cancel(true);
            }, timeoutMillis, TimeUnit.MILLISECONDS);
            vessel.whenComplete((__, ___) -> cancellation.cancel(true));
        }
        catch (Throwable thrown) {
            vessel.completeExceptionally(thrown);
        }
        vessel.whenComplete((__, ___) -> endpoint.inflight.decrementAndGet());
    }

    @Override
    public void close() {
        Throwable thrown = null;
        for (Endpoint endpoint : this.endpoints) {
            try {
                endpoint.client.close();
            }
            catch (Throwable t) {
                if (thrown == null) {
                    thrown = t;
                    continue;
                }
                thrown.addSuppressed(t);
            }
        }
        this.executor.shutdownNow().forEach(Runnable::run);
        if (thrown != null) {
            throw new RuntimeException(thrown);
        }
    }

    private static CloseableHttpAsyncClient createHttpClient(FeedClientBuilderImpl builder) throws IOException {
        SSLContext sslContext = builder.constructSslContext();
        String[] allowedCiphers = TlsCiphers.excludeH2Blacklisted((String[])TlsCiphers.excludeWeak((String[])sslContext.getSupportedSSLParameters().getCipherSuites()));
        if (allowedCiphers.length == 0) {
            throw new IllegalStateException("No adequate SSL cipher suites supported by the JVM");
        }
        ClientTlsStrategyBuilder tlsStrategyBuilder = ClientTlsStrategyBuilder.create().setTlsDetailsFactory(sslEngine -> new TlsDetails(sslEngine.getSession(), sslEngine.getApplicationProtocol())).setCiphers(allowedCiphers).setSslContext(sslContext);
        if (builder.hostnameVerifier != null) {
            tlsStrategyBuilder.setHostnameVerifier(builder.hostnameVerifier);
        }
        return HttpAsyncClients.createHttp2Minimal((H2Config)H2Config.custom().setMaxConcurrentStreams(builder.maxStreamsPerConnection).setCompressionEnabled(true).setPushEnabled(false).setInitialWindowSize(Integer.MAX_VALUE).build(), (IOReactorConfig)IOReactorConfig.custom().setIoThreadCount(2).setTcpNoDelay(true).setSoTimeout(Timeout.ofSeconds((long)10L)).build(), (TlsStrategy)tlsStrategyBuilder.build());
    }

    private static int portOf(URI url) {
        return url.getPort() == -1 ? (url.getScheme().equals("http") ? 80 : 443) : url.getPort();
    }

    private static RequestConfig createRequestConfig(FeedClientBuilderImpl b) {
        RequestConfig.Builder builder = RequestConfig.custom().setConnectTimeout(Timeout.ofSeconds((long)10L)).setConnectionRequestTimeout(Timeout.DISABLED).setResponseTimeout(Timeout.ofSeconds((long)190L));
        if (b.proxy != null) {
            builder.setProxy(new HttpHost(b.proxy.getScheme(), b.proxy.getHost(), b.proxy.getPort()));
        }
        return builder.build();
    }

    private static class Endpoint {
        private final CloseableHttpAsyncClient client;
        private final AtomicInteger inflight = new AtomicInteger(0);
        private final URI url;

        private Endpoint(CloseableHttpAsyncClient client, URI url) {
            this.client = client;
            this.url = url;
            this.client.start();
        }
    }

    private static class ApacheHttpResponse
    implements HttpResponse {
        private final SimpleHttpResponse wrapped;

        private ApacheHttpResponse(SimpleHttpResponse wrapped) {
            this.wrapped = wrapped;
        }

        public int code() {
            return this.wrapped.getCode();
        }

        public byte[] body() {
            return this.wrapped.getBodyBytes();
        }

        public String toString() {
            return "HTTP response with code " + this.code() + (this.body() != null ? " and body '" + new String(this.body(), StandardCharsets.UTF_8) + "'" : "");
        }
    }
}

