/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.feed.client;

import ai.vespa.feed.client.DocumentId;
import ai.vespa.feed.client.FeedClient;
import ai.vespa.feed.client.OperationParameters;
import ai.vespa.feed.client.Result;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class JsonFeeder
implements Closeable {
    private final ExecutorService resultExecutor = Executors.newSingleThreadExecutor(r -> {
        Thread t = new Thread(r, "json-feeder-result-executor");
        t.setDaemon(true);
        return t;
    });
    private final FeedClient client;
    private final OperationParameters protoParameters;
    private static final JsonFactory factory = new JsonFactory();

    private JsonFeeder(FeedClient client, OperationParameters protoParameters) {
        this.client = client;
        this.protoParameters = protoParameters;
    }

    public static Builder builder(FeedClient client) {
        return new Builder(client);
    }

    public CompletableFuture<Void> feedMany(InputStream jsonStream, ResultCallback resultCallback) {
        return this.feedMany(jsonStream, 0x4000000, resultCallback);
    }

    public CompletableFuture<Void> feedMany(InputStream jsonStream) {
        return this.feedMany(jsonStream, new ResultCallback(){});
    }

    CompletableFuture<Void> feedMany(InputStream jsonStream, int size, ResultCallback resultCallback) {
        CompletableFuture<Void> overallResult;
        block4: {
            RingBufferStream buffer = new RingBufferStream(jsonStream, size);
            overallResult = new CompletableFuture<Void>();
            AtomicInteger pending = new AtomicInteger(1);
            AtomicBoolean finalCallbackInvoked = new AtomicBoolean();
            try {
                CompletableFuture<Result> result;
                while ((result = buffer.next()) != null) {
                    pending.incrementAndGet();
                    result.whenCompleteAsync((r, t) -> {
                        if (!finalCallbackInvoked.get()) {
                            resultCallback.onNextResult((Result)r, (Throwable)t);
                        }
                        if (pending.decrementAndGet() == 0 && finalCallbackInvoked.compareAndSet(false, true)) {
                            resultCallback.onComplete();
                            overallResult.complete(null);
                        }
                    }, (Executor)this.resultExecutor);
                }
                if (pending.decrementAndGet() == 0 && finalCallbackInvoked.compareAndSet(false, true)) {
                    this.resultExecutor.execute(() -> {
                        resultCallback.onComplete();
                        overallResult.complete(null);
                    });
                }
            }
            catch (Exception e) {
                if (!finalCallbackInvoked.compareAndSet(false, true)) break block4;
                this.resultExecutor.execute(() -> {
                    resultCallback.onError(e);
                    overallResult.completeExceptionally(e);
                });
            }
        }
        return overallResult;
    }

    @Override
    public void close() throws IOException {
        this.client.close();
        this.resultExecutor.shutdown();
        try {
            if (!this.resultExecutor.awaitTermination(30L, TimeUnit.SECONDS)) {
                throw new IOException("Failed to close client in time");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static class Builder {
        final FeedClient client;
        OperationParameters parameters = OperationParameters.empty();

        private Builder(FeedClient client) {
            this.client = Objects.requireNonNull(client);
        }

        public Builder withTimeout(Duration timeout) {
            this.parameters = this.parameters.timeout(timeout);
            return this;
        }

        public Builder withRoute(String route) {
            this.parameters = this.parameters.route(route);
            return this;
        }

        public Builder withTracelevel(int tracelevel) {
            this.parameters = this.parameters.tracelevel(tracelevel);
            return this;
        }

        public JsonFeeder build() {
            return new JsonFeeder(this.client, this.parameters);
        }
    }

    private abstract class OperationParserAndExecutor {
        private final JsonParser parser;
        private final boolean multipleOperations;

        protected OperationParserAndExecutor(JsonParser parser, boolean multipleOperations) throws IOException {
            this.parser = parser;
            this.multipleOperations = multipleOperations;
            if (multipleOperations) {
                this.expect(JsonToken.START_ARRAY);
            }
        }

        abstract String getDocumentJson(long var1, long var3);

        CompletableFuture<Result> next() throws IOException {
            JsonToken token = this.parser.nextToken();
            if (token == JsonToken.END_ARRAY && this.multipleOperations) {
                return null;
            }
            if (token == null && !this.multipleOperations) {
                return null;
            }
            if (token != JsonToken.START_OBJECT) {
                throw new IllegalArgumentException("Unexpected token '" + (Object)((Object)this.parser.currentToken()) + "' at offset " + this.parser.getTokenLocation().getByteOffset());
            }
            long start = 0L;
            long end = -1L;
            FeedClient.OperationType type = null;
            DocumentId id = null;
            OperationParameters parameters = JsonFeeder.this.protoParameters;
            block30: while (true) {
                switch (this.parser.nextToken()) {
                    case FIELD_NAME: {
                        switch (this.parser.getText()) {
                            case "id": 
                            case "put": {
                                type = FeedClient.OperationType.PUT;
                                id = this.readId();
                                continue block30;
                            }
                            case "update": {
                                type = FeedClient.OperationType.UPDATE;
                                id = this.readId();
                                continue block30;
                            }
                            case "remove": {
                                type = FeedClient.OperationType.REMOVE;
                                id = this.readId();
                                continue block30;
                            }
                            case "condition": {
                                parameters = parameters.testAndSetCondition(this.readString());
                                continue block30;
                            }
                            case "create": {
                                parameters = parameters.createIfNonExistent(this.readBoolean());
                                continue block30;
                            }
                            case "fields": {
                                this.expect(JsonToken.START_OBJECT);
                                start = this.parser.getTokenLocation().getByteOffset();
                                int depth = 1;
                                while (depth > 0) {
                                    switch (this.parser.nextToken()) {
                                        case START_OBJECT: {
                                            ++depth;
                                            break;
                                        }
                                        case END_OBJECT: {
                                            --depth;
                                        }
                                    }
                                }
                                end = this.parser.getTokenLocation().getByteOffset() + 1L;
                                continue block30;
                            }
                        }
                        throw new IllegalArgumentException("Unexpected field name '" + this.parser.getText() + "' at offset " + this.parser.getTokenLocation().getByteOffset());
                    }
                    case END_OBJECT: {
                        break block30;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected token '" + (Object)((Object)this.parser.currentToken()) + "' at offset " + this.parser.getTokenLocation().getByteOffset());
                    }
                }
                break;
            }
            if (id == null) {
                throw new IllegalArgumentException("No document id for document at offset " + start);
            }
            if (end < start) {
                throw new IllegalArgumentException("No 'fields' object for document at offset " + this.parser.getTokenLocation().getByteOffset());
            }
            String payload = this.getDocumentJson(start, end);
            switch (type) {
                case PUT: {
                    return JsonFeeder.this.client.put(id, payload, parameters);
                }
                case UPDATE: {
                    return JsonFeeder.this.client.update(id, payload, parameters);
                }
                case REMOVE: {
                    return JsonFeeder.this.client.remove(id, parameters);
                }
            }
            throw new IllegalStateException("Unexpected operation type '" + (Object)((Object)type) + "'");
        }

        void expect(JsonToken token) throws IOException {
            if (this.parser.nextToken() != token) {
                throw new IllegalArgumentException("Expected '" + (Object)((Object)token) + "' at offset " + this.parser.getTokenLocation().getByteOffset() + ", but found '" + (Object)((Object)this.parser.currentToken()) + "' (" + this.parser.getText() + ")");
            }
        }

        private String readString() throws IOException {
            String value = this.parser.nextTextValue();
            if (value == null) {
                throw new IllegalArgumentException("Expected '" + (Object)((Object)JsonToken.VALUE_STRING) + "' at offset " + this.parser.getTokenLocation().getByteOffset() + ", but found '" + (Object)((Object)this.parser.currentToken()) + "' (" + this.parser.getText() + ")");
            }
            return value;
        }

        private boolean readBoolean() throws IOException {
            Boolean value = this.parser.nextBooleanValue();
            if (value == null) {
                throw new IllegalArgumentException("Expected '" + (Object)((Object)JsonToken.VALUE_FALSE) + "' or '" + (Object)((Object)JsonToken.VALUE_TRUE) + "' at offset " + this.parser.getTokenLocation().getByteOffset() + ", but found '" + (Object)((Object)this.parser.currentToken()) + "' (" + this.parser.getText() + ")");
            }
            return value;
        }

        private DocumentId readId() throws IOException {
            return DocumentId.of(this.readString());
        }
    }

    private class RingBufferStream
    extends InputStream {
        private final byte[] b = new byte[1];
        private final InputStream in;
        private final byte[] data;
        private final int size;
        private final Object lock = new Object();
        private Throwable thrown = null;
        private long tail = 0L;
        private long pos = 0L;
        private long head = 0L;
        private boolean done = false;
        private final OperationParserAndExecutor parserAndExecutor;
        private final byte[] prefix = "{\"fields\":".getBytes(StandardCharsets.UTF_8);

        RingBufferStream(InputStream in, int size) {
            this.in = in;
            this.data = new byte[size];
            this.size = size;
            new Thread(this::fill, "feed-reader").start();
            try {
                this.parserAndExecutor = new RingBufferBackedOperationParserAndExecutor(factory.createParser(this));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public int read() throws IOException {
            return this.read(this.b, 0, 1) == -1 ? -1 : this.b[0];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] buffer, int off, int len) throws IOException {
            try {
                int ready;
                Object object = this.lock;
                synchronized (object) {
                    while ((ready = (int)(this.head - this.pos)) == 0 && !this.done) {
                        this.lock.wait();
                    }
                }
                if (this.thrown != null) {
                    throw new RuntimeException("Error reading input", this.thrown);
                }
                if (ready == 0) {
                    return -1;
                }
                ready = Math.min(ready, len);
                int offset = (int)(this.pos % (long)this.size);
                int length = Math.min(ready, this.size - offset);
                System.arraycopy(this.data, offset, buffer, off, length);
                if (length < ready) {
                    System.arraycopy(this.data, 0, buffer, off + length, ready - length);
                }
                this.pos += (long)ready;
                return ready;
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException("Interrupted waiting for data: " + e.getMessage());
            }
        }

        public CompletableFuture<Result> next() throws IOException {
            return this.parserAndExecutor.next();
        }

        private byte[] copy(long start, long end) {
            int length = (int)(end - start);
            byte[] buffer = new byte[this.prefix.length + length + 1];
            System.arraycopy(this.prefix, 0, buffer, 0, this.prefix.length);
            int offset = (int)(start % (long)this.size);
            int toWrite = Math.min(length, this.size - offset);
            System.arraycopy(this.data, offset, buffer, this.prefix.length, toWrite);
            if (toWrite < length) {
                System.arraycopy(this.data, 0, buffer, this.prefix.length + toWrite, length - toWrite);
            }
            buffer[buffer.length - 1] = 125;
            return buffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                this.done = true;
                this.lock.notifyAll();
            }
            this.in.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private void fill() {
            try {
                while (true) {
                    int free;
                    Object object = this.lock;
                    // MONITORENTER : object
                    while ((free = (int)(this.tail + (long)this.size - this.head)) <= 0 && !this.done) {
                        this.lock.wait();
                    }
                    // MONITOREXIT : object
                    if (this.done) {
                        return;
                    }
                    int off = (int)(this.head % (long)this.size);
                    int len = Math.min(Math.min(free, this.size - off), 8192);
                    int read = this.in.read(this.data, off, len);
                    Object object2 = this.lock;
                    // MONITORENTER : object2
                    if (read < 0) {
                        this.done = true;
                    } else {
                        this.head += (long)read;
                    }
                    this.lock.notify();
                    // MONITOREXIT : object2
                }
            }
            catch (Throwable t) {
                Object object = this.lock;
                // MONITORENTER : object
                this.done = true;
                this.thrown = t;
                // MONITOREXIT : object
                return;
            }
        }

        private class RingBufferBackedOperationParserAndExecutor
        extends OperationParserAndExecutor {
            RingBufferBackedOperationParserAndExecutor(JsonParser parser) throws IOException {
                super(parser, true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            String getDocumentJson(long start, long end) {
                String payload = new String(RingBufferStream.this.copy(start, end), StandardCharsets.UTF_8);
                Object object = RingBufferStream.this.lock;
                synchronized (object) {
                    RingBufferStream.this.tail = end;
                    RingBufferStream.this.lock.notify();
                }
                return payload;
            }
        }
    }

    public static interface ResultCallback {
        default public void onNextResult(Result result, Throwable error) {
        }

        default public void onError(Throwable error) {
        }

        default public void onComplete() {
        }
    }
}

