/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.feed.client;

import ai.vespa.feed.client.FeedClient;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongSupplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GracePeriodCircuitBreaker
implements FeedClient.CircuitBreaker {
    private static final Logger log = Logger.getLogger(GracePeriodCircuitBreaker.class.getName());
    private static final long NEVER = 0x1000000000000000L;
    private final AtomicLong failingSinceMillis = new AtomicLong(0x1000000000000000L);
    private final AtomicBoolean halfOpen = new AtomicBoolean(false);
    private final AtomicBoolean open = new AtomicBoolean(false);
    private final LongSupplier clock;
    private final long graceMillis;
    private final long doomMillis;

    public GracePeriodCircuitBreaker(Duration grace, Duration doom) {
        this(System::currentTimeMillis, grace, doom);
    }

    GracePeriodCircuitBreaker(LongSupplier clock, Duration grace, Duration doom) {
        if (grace.isNegative()) {
            throw new IllegalArgumentException("Grace delay must be non-negative");
        }
        if (doom.isNegative()) {
            throw new IllegalArgumentException("Doom delay must be non-negative");
        }
        this.clock = Objects.requireNonNull(clock);
        this.graceMillis = grace.toMillis();
        this.doomMillis = doom.toMillis();
    }

    @Override
    public void success() {
        this.failingSinceMillis.set(0x1000000000000000L);
        if (!this.open.get() && this.halfOpen.compareAndSet(true, false)) {
            log.log(Level.INFO, "Circuit breaker is now closed");
        }
    }

    @Override
    public void failure() {
        this.failingSinceMillis.compareAndSet(0x1000000000000000L, this.clock.getAsLong());
    }

    @Override
    public FeedClient.CircuitBreaker.State state() {
        long failingMillis = this.clock.getAsLong() - this.failingSinceMillis.get();
        if (failingMillis > this.graceMillis && this.halfOpen.compareAndSet(false, true)) {
            log.log(Level.INFO, "Circuit breaker is now half-open");
        }
        if (failingMillis > this.doomMillis && this.open.compareAndSet(false, true)) {
            log.log(Level.WARNING, "Circuit breaker is now open");
        }
        return this.open.get() ? FeedClient.CircuitBreaker.State.OPEN : (this.halfOpen.get() ? FeedClient.CircuitBreaker.State.HALF_OPEN : FeedClient.CircuitBreaker.State.CLOSED);
    }
}

