/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.feed.client;

import ai.vespa.feed.client.DocumentId;
import ai.vespa.feed.client.OperationParameters;
import ai.vespa.feed.client.Result;
import java.io.Closeable;
import java.util.concurrent.CompletableFuture;

public interface FeedClient
extends Closeable {
    public CompletableFuture<Result> put(DocumentId var1, String var2, OperationParameters var3);

    public CompletableFuture<Result> update(DocumentId var1, String var2, OperationParameters var3);

    public CompletableFuture<Result> remove(DocumentId var1, OperationParameters var2);

    public void close(boolean var1);

    @Override
    default public void close() {
        this.close(true);
    }

    public static enum OperationType {
        PUT,
        UPDATE,
        REMOVE;

    }

    public static interface CircuitBreaker {
        public void success();

        public void failure();

        public State state();

        public static enum State {
            CLOSED,
            HALF_OPEN,
            OPEN;

        }
    }

    public static interface RetryStrategy {
        default public boolean retry(OperationType type) {
            return true;
        }

        default public int retries() {
            return 32;
        }
    }
}

