/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.feed.client;

import ai.vespa.feed.client.DocumentId;
import ai.vespa.feed.client.FeedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class MultiFeedException
extends RuntimeException {
    private final List<FeedException> exceptions;

    public MultiFeedException(Collection<FeedException> exceptions) {
        super(MultiFeedException.toMessage(exceptions));
        this.exceptions = Collections.unmodifiableList(new ArrayList<FeedException>(exceptions));
    }

    public Collection<FeedException> feedExceptions() {
        return this.exceptions;
    }

    public Set<DocumentId> documentIds() {
        return this.exceptions.stream().filter(e -> e.documentId().isPresent()).map(e -> e.documentId().get()).collect(Collectors.toSet());
    }

    private static String toMessage(Collection<FeedException> exceptions) {
        return String.format("%d feed operations failed", exceptions.size());
    }
}

