/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.feed.client;

import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;

public class DocumentId {
    private final String documentType;
    private final String namespace;
    private final OptionalLong number;
    private final Optional<String> group;
    private final String userSpecific;

    private DocumentId(String documentType, String namespace, OptionalLong number, Optional<String> group, String userSpecific) {
        this.documentType = Objects.requireNonNull(documentType);
        this.namespace = Objects.requireNonNull(namespace);
        this.number = Objects.requireNonNull(number);
        this.group = Objects.requireNonNull(group);
        this.userSpecific = Objects.requireNonNull(userSpecific);
    }

    public static DocumentId of(String namespace, String documentType, String userSpecific) {
        return new DocumentId(documentType, namespace, OptionalLong.empty(), Optional.empty(), userSpecific);
    }

    public static DocumentId of(String namespace, String documentType, long number, String userSpecific) {
        return new DocumentId(documentType, namespace, OptionalLong.of(number), Optional.empty(), userSpecific);
    }

    public static DocumentId of(String namespace, String documentType, String group, String userSpecific) {
        return new DocumentId(documentType, namespace, OptionalLong.empty(), Optional.of(group), userSpecific);
    }

    public static DocumentId of(String serialized) {
        DocumentId parsed = DocumentId.parse(serialized);
        if (parsed != null) {
            return parsed;
        }
        throw new IllegalArgumentException("Document ID must be on the form 'id:<namespace>:<document-type>:[n=<number>|g=<group>]:<user-specific>', but was '" + serialized + "'");
    }

    private static DocumentId parse(String serialized) {
        int j = -1;
        int i = j + 1;
        if ((j = serialized.indexOf(58, i)) < i) {
            return null;
        }
        if (!"id".equals(serialized.substring(i, j))) {
            return null;
        }
        i = j + 1;
        if ((j = serialized.indexOf(58, i)) <= i) {
            return null;
        }
        String namespace = serialized.substring(i, j);
        i = j + 1;
        if ((j = serialized.indexOf(58, i)) <= i) {
            return null;
        }
        String documentType = serialized.substring(i, j);
        i = j + 1;
        if ((j = serialized.indexOf(58, i)) < i) {
            return null;
        }
        String group = serialized.substring(i, j);
        i = j + 1;
        if (serialized.length() <= i) {
            return null;
        }
        String userSpecific = serialized.substring(i);
        if (group.startsWith("n=") && group.length() > 2) {
            return DocumentId.of(namespace, documentType, Long.parseLong(group.substring(2)), userSpecific);
        }
        if (group.startsWith("g=") && group.length() > 2) {
            return DocumentId.of(namespace, documentType, group.substring(2), userSpecific);
        }
        if (group.isEmpty()) {
            return DocumentId.of(namespace, documentType, userSpecific);
        }
        return null;
    }

    public String documentType() {
        return this.documentType;
    }

    public String namespace() {
        return this.namespace;
    }

    public OptionalLong number() {
        return this.number;
    }

    public Optional<String> group() {
        return this.group;
    }

    public String userSpecific() {
        return this.userSpecific;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentId that = (DocumentId)o;
        return this.documentType.equals(that.documentType) && this.namespace.equals(that.namespace) && this.number.equals(that.number) && this.group.equals(that.group) && this.userSpecific.equals(that.userSpecific);
    }

    public int hashCode() {
        return Objects.hash(this.documentType, this.namespace, this.number, this.group, this.userSpecific);
    }

    public String toString() {
        return "id:" + this.namespace + ":" + this.documentType + ":" + (String)(this.number.isPresent() ? "n=" + this.number.getAsLong() : this.group.map("g="::concat).orElse("")) + ":" + this.userSpecific;
    }
}

