/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.maven.plugin.enforcer;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.enforcer.rule.api.AbstractEnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

@Named(value="allowedDependencies")
public class AllowedDependencies
extends AbstractEnforcerRule
implements EnforcerRule {
    private static final String WRITE_SPEC_PROP = "dependencyEnforcer.writeSpec";
    private static final String GUESS_VERSION = "dependencyEnforcer.guessProperty";
    @Inject
    private MavenProject project;
    @Inject
    private MavenSession session;
    @Inject
    private DependencyGraphBuilder graphBuilder;
    public List<String> ignored;
    public String rootProjectId;
    public String specFile;

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        try {
            this.project = (MavenProject)helper.evaluate("${project}");
            this.session = (MavenSession)helper.evaluate("${session}");
            this.graphBuilder = (DependencyGraphBuilder)helper.getComponent(DependencyGraphBuilder.class);
        }
        catch (ExpressionEvaluationException | ComponentLookupException e) {
            throw new RuntimeException(e);
        }
        this.execute();
    }

    public void execute() throws EnforcerRuleException {
        Set<Dependency> dependencies = this.getDependenciesOfAllProjects();
        this.getLog().info((CharSequence)"Found %d unique dependencies ".formatted(dependencies.size()));
        Path specFile = Paths.get(String.valueOf(this.project.getBasedir()) + File.separator + this.specFile, new String[0]).normalize();
        List<Rule> spec = this.loadDependencySpec(specFile);
        Resolved resolved = this.resolve(spec, dependencies);
        if (System.getProperties().containsKey(WRITE_SPEC_PROP)) {
            Boolean guessProperty = Optional.ofNullable(System.getProperty(GUESS_VERSION)).map(p -> p.isEmpty() || Boolean.parseBoolean(p)).orElse(true);
            this.writeDependencySpec(specFile, resolved, guessProperty);
            this.getLog().info((CharSequence)"Updated spec file '%s'".formatted(specFile.toString()));
        } else {
            this.warnOnDuplicateVersions(resolved);
            AllowedDependencies.validateDependencies(resolved, this.session.getRequest().getPom().toPath(), this.project.getArtifactId());
        }
        this.getLog().info((CharSequence)"The dependency enforcer completed successfully");
    }

    private static void validateDependencies(Resolved resolved, Path aggregatorPomRoot, String moduleName) throws EnforcerRuleException {
        if (!resolved.unmatchedRules().isEmpty() || !resolved.unmatchedDeps().isEmpty()) {
            StringBuilder errorMsg = new StringBuilder("The dependency enforcer failed:\n");
            if (!resolved.unmatchedRules().isEmpty()) {
                errorMsg.append("Rules not matching any dependency:\n");
                resolved.unmatchedRules().forEach(r -> errorMsg.append(" - ").append(r.asString()).append('\n'));
            }
            if (!resolved.unmatchedDeps().isEmpty()) {
                errorMsg.append("Dependencies not matching any rule:\n");
                resolved.unmatchedDeps().forEach(d -> errorMsg.append(" - ").append(d.asString(null)).append('\n'));
            }
            throw new EnforcerRuleException(errorMsg.append("Maven dependency validation failed. ").append("If this change was intentional, update the dependency spec by running:\n").append("$ mvn validate -D").append(WRITE_SPEC_PROP).append(" -pl :").append(moduleName).append(" -f ").append(aggregatorPomRoot).append("\n").toString());
        }
    }

    private Set<Dependency> getDependenciesOfAllProjects() throws EnforcerRuleException {
        try {
            Pattern depIgnorePattern = Pattern.compile(this.ignored.stream().map(s -> s.replace(".", "\\.").replace("*", ".*").replace(":", "\\:").replace('?', '.')).collect(Collectors.joining(")|(", "^(", ")$")));
            List<MavenProject> projects = AllowedDependencies.getAllProjects(this.session, this.rootProjectId);
            HashSet<Dependency> dependencies = new HashSet<Dependency>();
            for (MavenProject project : projects) {
                DefaultProjectBuildingRequest req = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
                req.setProject(project);
                DependencyNode root = this.graphBuilder.buildDependencyGraph((ProjectBuildingRequest)req, null);
                AllowedDependencies.addDependenciesRecursive(root, dependencies, depIgnorePattern);
            }
            return Set.copyOf(dependencies);
        }
        catch (DependencyGraphBuilderException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static void addDependenciesRecursive(DependencyNode node, Set<Dependency> dependencies, Pattern ignored) {
        if (node.getChildren() != null) {
            for (DependencyNode dep : node.getChildren()) {
                Artifact a = dep.getArtifact();
                Dependency dependency = Dependency.fromArtifact(a);
                if (!ignored.matcher(dependency.asString(null)).matches()) {
                    dependencies.add(dependency);
                }
                AllowedDependencies.addDependenciesRecursive(dep, dependencies, ignored);
            }
        }
    }

    private static List<MavenProject> getAllProjects(MavenSession session, String rootProjectId) throws EnforcerRuleException {
        if (rootProjectId == null) {
            throw new EnforcerRuleException("Missing required <rootProjectId> in <enforceDependencies> in pom.xml");
        }
        List allProjects = session.getAllProjects();
        if (allProjects.size() == 1) {
            throw new EnforcerRuleException("Only a single Maven module detected. Enforcer must be executed from root of aggregator pom.");
        }
        MavenProject rootProject = allProjects.stream().filter(project -> rootProjectId.equals(AllowedDependencies.projectIdOf(project))).findAny().orElseThrow(() -> new EnforcerRuleException("Root project not found: " + rootProjectId));
        Map<Path, MavenProject> projectsByBaseDir = allProjects.stream().collect(Collectors.toMap(project -> project.getBasedir().toPath().normalize(), project -> project));
        ArrayList<MavenProject> projects = new ArrayList<MavenProject>();
        ArrayDeque<MavenProject> pendingProjects = new ArrayDeque<MavenProject>();
        pendingProjects.add(rootProject);
        while (!pendingProjects.isEmpty()) {
            MavenProject project2 = (MavenProject)pendingProjects.pop();
            projects.add(project2);
            for (String module : project2.getModules()) {
                Path moduleBaseDir = project2.getBasedir().toPath().resolve(module).normalize();
                MavenProject moduleProject = projectsByBaseDir.get(moduleBaseDir);
                if (moduleProject == null) {
                    throw new EnforcerRuleException("Failed to find module '" + module + "' in project " + String.valueOf(project2.getBasedir()));
                }
                pendingProjects.add(moduleProject);
            }
        }
        projects.sort(Comparator.comparing(AllowedDependencies::projectIdOf));
        return projects;
    }

    private List<Rule> loadDependencySpec(Path specFile) {
        List<Rule> list;
        block8: {
            Stream<String> s = Files.lines(specFile);
            try {
                list = s.map(String::trim).filter(l -> !l.isEmpty() && !l.startsWith("#")).map(Rule::fromString).toList();
                if (s == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            s.close();
        }
        return list;
    }

    private Resolved resolve(List<Rule> spec, Set<Dependency> dependencies) {
        HashSet<Dependency> resolvedDeps = new HashSet<Dependency>();
        HashSet<Rule> resolveRules = new HashSet<Rule>();
        HashSet<Dependency> unmatchedDeps = new HashSet<Dependency>();
        HashSet<Rule> unmatchedRules = new HashSet<Rule>();
        for (Rule rule : spec) {
            Dependency requiredDependency = rule.resolveToDependency(this.project.getProperties());
            if (dependencies.contains(requiredDependency)) {
                resolvedDeps.add(requiredDependency);
                resolveRules.add(rule);
                continue;
            }
            unmatchedRules.add(rule);
        }
        for (Dependency dependency : dependencies) {
            if (resolvedDeps.contains(dependency)) continue;
            unmatchedDeps.add(dependency);
        }
        return new Resolved(resolvedDeps, resolveRules, unmatchedDeps, unmatchedRules);
    }

    void writeDependencySpec(Path specFile, Resolved resolved, boolean guessVersion) {
        TreeSet content = new TreeSet();
        resolved.matchedRules().forEach(r -> content.add(r.asString()));
        resolved.unmatchedDeps().forEach(d -> content.add(d.asString(guessVersion ? this.project.getProperties() : null)));
        try (BufferedWriter out = Files.newBufferedWriter(specFile, new OpenOption[0]);){
            out.write("# Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.\n\n");
            for (String line : content) {
                out.write(line);
                out.write(10);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void warnOnDuplicateVersions(Resolved resolved) {
        TreeMap<String, Set> versionsForDependency = new TreeMap<String, Set>();
        HashSet<Dependency> allDeps = new HashSet<Dependency>(resolved.matchedDeps());
        allDeps.addAll(resolved.unmatchedDeps());
        for (Dependency d : allDeps) {
            String id = "%s:%s".formatted(d.groupId(), d.artifactId());
            versionsForDependency.computeIfAbsent(id, __ -> new TreeSet()).add(d.version());
        }
        versionsForDependency.forEach((dependency, versions) -> {
            if (versions.size() > 1) {
                this.getLog().warn((CharSequence)"'%s' has multiple versions %s".formatted(dependency, versions));
            }
        });
    }

    private static String projectIdOf(MavenProject project) {
        return "%s:%s".formatted(project.getGroupId(), project.getArtifactId());
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(EnforcerRule r) {
        return false;
    }

    public String getCacheId() {
        return "";
    }

    record Resolved(Set<Dependency> matchedDeps, Set<Rule> matchedRules, Set<Dependency> unmatchedDeps, Set<Rule> unmatchedRules) {
    }

    record Dependency(String groupId, String artifactId, String version, Optional<String> classifier) {
        static Dependency fromArtifact(Artifact a) {
            return new Dependency(a.getGroupId(), a.getArtifactId(), a.getVersion(), Optional.ofNullable(a.getClassifier()));
        }

        String asString(Properties props) {
            String matchingProps;
            String versionStr = this.version;
            if (props != null && !(matchingProps = props.entrySet().stream().filter(e -> e.getValue().equals(this.version)).map(v -> "${%s}".formatted(v.getKey())).collect(Collectors.joining("|"))).isEmpty()) {
                versionStr = matchingProps;
            }
            StringBuilder b = new StringBuilder(this.groupId).append(':').append(this.artifactId).append(':').append(versionStr);
            this.classifier.ifPresent(c -> b.append(':').append((String)c));
            return b.toString();
        }
    }

    private record Rule(String groupId, String artifactId, String version, Optional<String> classifier) {
        static final Pattern PROPERTY_PATTERN = Pattern.compile("\\$\\{(.+?)}");

        static Rule fromString(String s) {
            String[] splits = s.split(":");
            return splits.length == 3 ? new Rule(splits[0], splits[1], splits[2], Optional.empty()) : new Rule(splits[0], splits[1], splits[2], Optional.of(splits[3]));
        }

        Dependency resolveToDependency(Properties props) {
            Matcher matcher = PROPERTY_PATTERN.matcher(this.version);
            String resolvedVersion = this.version;
            while (matcher.find()) {
                String property = matcher.group(1);
                String value = props.getProperty(property);
                if (value == null) {
                    throw new IllegalArgumentException("Missing property: " + property);
                }
                resolvedVersion = this.version.replace(matcher.group(), value);
            }
            return new Dependency(this.groupId, this.artifactId, resolvedVersion, this.classifier);
        }

        String asString() {
            StringBuilder b = new StringBuilder(this.groupId).append(':').append(this.artifactId).append(':').append(this.version);
            this.classifier.ifPresent(c -> b.append(':').append((String)c));
            return b.toString();
        }
    }
}

