/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.maven.plugin.enforcer;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.enforcer.rules.utils.ArtifactMatcher;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

public class EnforceDependencies
implements EnforcerRule {
    private List<String> allowedDependencies = List.of();
    private boolean failOnUnmatched = true;

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        EnforceDependencies.validateDependencies(EnforceDependencies.getAllDependencies(helper), Set.copyOf(this.allowedDependencies), this.failOnUnmatched);
        helper.getLog().info((CharSequence)"The 'enforceDependencies' validation completed successfully");
    }

    static void validateDependencies(Set<Artifact> dependencies, Set<String> allowedRules, boolean failOnUnmatched) throws EnforcerRuleException {
        TreeSet<Artifact> unmatchedArtifacts = new TreeSet<Artifact>();
        HashSet<String> matchedRules = new HashSet<String>();
        for (Artifact dependency : dependencies) {
            boolean matches = false;
            for (String rule : allowedRules) {
                if (!EnforceDependencies.matches(dependency, rule)) continue;
                matchedRules.add(rule);
                matches = true;
                break;
            }
            if (matches) continue;
            unmatchedArtifacts.add(dependency);
        }
        TreeSet<String> unmatchedRules = new TreeSet<String>(allowedRules);
        unmatchedRules.removeAll(matchedRules);
        if (!unmatchedArtifacts.isEmpty() || failOnUnmatched && !unmatchedRules.isEmpty()) {
            StringBuilder errorMessage = new StringBuilder("Vespa dependency enforcer failed:\n");
            if (!unmatchedArtifacts.isEmpty()) {
                errorMessage.append("Dependencies not matching any rule:\n");
                unmatchedArtifacts.forEach(a -> errorMessage.append(" - ").append(a.toString()).append('\n'));
            }
            if (failOnUnmatched && !unmatchedRules.isEmpty()) {
                errorMessage.append("Rules not matching any dependency:\n");
                unmatchedRules.forEach(p -> errorMessage.append(" - ").append((String)p).append('\n'));
            }
            throw new EnforcerRuleException(errorMessage.toString());
        }
    }

    private static Set<Artifact> getAllDependencies(EnforcerRuleHelper helper) throws EnforcerRuleException {
        try {
            MavenProject project = (MavenProject)helper.evaluate("${project}");
            MavenSession session = (MavenSession)helper.evaluate("${session}");
            DependencyGraphBuilder graphBuilder = (DependencyGraphBuilder)helper.getComponent(DependencyGraphBuilder.class);
            DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(session.getProjectBuildingRequest());
            buildingRequest.setProject(project);
            DependencyNode root = graphBuilder.buildDependencyGraph((ProjectBuildingRequest)buildingRequest, null);
            return EnforceDependencies.getAllRecursive(root);
        }
        catch (DependencyGraphBuilderException | ExpressionEvaluationException | ComponentLookupException e) {
            throw new EnforcerRuleException(e.getMessage(), (Exception)e);
        }
    }

    private static Set<Artifact> getAllRecursive(DependencyNode node) {
        LinkedHashSet<Artifact> children = new LinkedHashSet<Artifact>();
        if (node.getChildren() != null) {
            for (DependencyNode dep : node.getChildren()) {
                children.add(dep.getArtifact());
                children.addAll(EnforceDependencies.getAllRecursive(dep));
            }
        }
        return children;
    }

    private static boolean matches(Artifact dependency, String rule) throws EnforcerRuleException {
        String[] segments = rule.split(":");
        if (segments.length < 4 || segments.length > 6) {
            throw new EnforcerRuleException("Invalid rule: " + rule);
        }
        int index = 0;
        if (!EnforceDependencies.segmentMatches(dependency.getGroupId(), segments[index++])) {
            return false;
        }
        if (!EnforceDependencies.segmentMatches(dependency.getArtifactId(), segments[index++])) {
            return false;
        }
        if (segments.length >= 5 && !EnforceDependencies.segmentMatches(dependency.getType(), segments[index++])) {
            return false;
        }
        if (segments.length == 6 ? !dependency.hasClassifier() || !EnforceDependencies.segmentMatches(dependency.getClassifier(), segments[index++]) : dependency.hasClassifier()) {
            return false;
        }
        if (!EnforceDependencies.versionMatches(dependency.getVersion(), segments[index++])) {
            return false;
        }
        return EnforceDependencies.segmentMatches(dependency.getScope(), segments[index]);
    }

    private static boolean segmentMatches(String value, String segmentPattern) {
        String regex = segmentPattern.replace(".", "\\.").replace("*", ".*").replace(":", "\\:").replace('?', '.').replace("(", "\\(").replace(")", "\\)").replace("[", "\\[").replace("]", "\\]");
        return Pattern.matches(regex, value);
    }

    private static boolean versionMatches(String rawVersion, String segmentPattern) throws EnforcerRuleException {
        if (EnforceDependencies.segmentMatches(rawVersion, segmentPattern)) {
            return true;
        }
        if (!segmentPattern.startsWith("[") && !segmentPattern.startsWith("(")) {
            return false;
        }
        try {
            VersionRange range = VersionRange.createFromVersionSpec((String)segmentPattern);
            return ArtifactMatcher.containsVersion((VersionRange)range, (ArtifactVersion)new DefaultArtifactVersion(rawVersion));
        }
        catch (InvalidVersionSpecificationException e) {
            throw new EnforcerRuleException("Invalid version range: " + segmentPattern, (Exception)((Object)e));
        }
    }

    public void setAllowed(List<String> allowed) {
        this.allowedDependencies = allowed;
    }

    public List<String> getAllowed() {
        return this.allowedDependencies;
    }

    public void setFailOnUnmatchedRule(boolean enabled) {
        this.failOnUnmatched = enabled;
    }

    public boolean isFailOnUnmatchedRule() {
        return this.failOnUnmatched;
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(EnforcerRule enforcerRule) {
        return false;
    }

    public String getCacheId() {
        return "";
    }
}

