/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vdslib.state;

import com.yahoo.text.StringUtilities;
import com.yahoo.vdslib.state.Diff;
import com.yahoo.vdslib.state.Node;
import com.yahoo.vdslib.state.NodeState;
import com.yahoo.vdslib.state.NodeType;
import com.yahoo.vdslib.state.State;
import java.text.ParseException;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;

public class ClusterState
implements Cloneable {
    private static final NodeState DEFAULT_STORAGE_UP_NODE_STATE = new NodeState(NodeType.STORAGE, State.UP);
    private static final NodeState DEFAULT_DISTRIBUTOR_UP_NODE_STATE = new NodeState(NodeType.DISTRIBUTOR, State.UP);
    private static final NodeState DEFAULT_STORAGE_DOWN_NODE_STATE = new NodeState(NodeType.STORAGE, State.DOWN);
    private static final NodeState DEFAULT_DISTRIBUTOR_DOWN_NODE_STATE = new NodeState(NodeType.DISTRIBUTOR, State.DOWN);
    private int version = 0;
    private State state = State.DOWN;
    private String description = "";
    private int distributionBits = 16;
    private final Nodes distributorNodes;
    private final Nodes storageNodes;

    public ClusterState(String serialized) throws ParseException {
        this.distributorNodes = new Nodes(NodeType.DISTRIBUTOR);
        this.storageNodes = new Nodes(NodeType.STORAGE);
        this.deserialize(serialized);
    }

    public ClusterState(ClusterState b) {
        this.version = b.version;
        this.state = b.state;
        this.description = b.description;
        this.distributionBits = b.distributionBits;
        this.distributorNodes = new Nodes(b.distributorNodes);
        this.storageNodes = new Nodes(b.storageNodes);
    }

    private Nodes getNodes(NodeType type) {
        return type == NodeType.STORAGE ? this.storageNodes : (type == NodeType.DISTRIBUTOR ? this.distributorNodes : null);
    }

    public static ClusterState stateFromString(String stateStr) {
        try {
            return new ClusterState(stateStr);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ClusterState emptyState() {
        return ClusterState.stateFromString("");
    }

    public ClusterState clone() {
        return new ClusterState(this);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ClusterState)) {
            return false;
        }
        ClusterState other = (ClusterState)o;
        return this.version == other.version && this.state.equals((Object)other.state) && this.distributionBits == other.distributionBits && this.distributorNodes.equals(other.distributorNodes) && this.storageNodes.equals(other.storageNodes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.version, this.state, this.distributionBits, this.distributorNodes, this.storageNodes});
    }

    public boolean similarTo(Object o) {
        if (!(o instanceof ClusterState)) {
            return false;
        }
        ClusterState other = (ClusterState)o;
        return this.similarToImpl(other, this::normalizedNodeStateSimilarTo);
    }

    public boolean similarToIgnoringInitProgress(ClusterState other) {
        return this.similarToImpl(other, this::normalizedNodeStateSimilarToIgnoringInitProgress);
    }

    private boolean similarToImpl(ClusterState other, NodeStateCmp nodeStateCmp) {
        if (other == this) {
            return true;
        }
        if (this.state.equals((Object)State.DOWN) && other.state.equals((Object)State.DOWN)) {
            return true;
        }
        if (!this.metaInformationSimilarTo(other)) {
            return false;
        }
        if (!this.distributorNodes.similarToImpl(other.distributorNodes, nodeStateCmp)) {
            return false;
        }
        return this.storageNodes.similarToImpl(other.storageNodes, nodeStateCmp);
    }

    private boolean metaInformationSimilarTo(ClusterState other) {
        if (this.version != other.version || !this.state.equals((Object)other.state)) {
            return false;
        }
        return this.distributionBits == other.distributionBits;
    }

    private boolean normalizedNodeStateSimilarTo(NodeType nodeType, NodeState lhs, NodeState rhs) {
        NodeState lhsNormalized = lhs != null ? lhs : ClusterState.defaultUpNodeState(nodeType);
        NodeState rhsNormalized = rhs != null ? rhs : ClusterState.defaultUpNodeState(nodeType);
        return lhsNormalized.similarTo(rhsNormalized);
    }

    private boolean normalizedNodeStateSimilarToIgnoringInitProgress(NodeType nodeType, NodeState lhs, NodeState rhs) {
        NodeState lhsNormalized = lhs != null ? lhs : ClusterState.defaultUpNodeState(nodeType);
        NodeState rhsNormalized = rhs != null ? rhs : ClusterState.defaultUpNodeState(nodeType);
        return lhsNormalized.similarToIgnoringInitProgress(rhsNormalized);
    }

    private static NodeState defaultUpNodeState(NodeType nodeType) {
        return nodeType == NodeType.STORAGE ? DEFAULT_STORAGE_UP_NODE_STATE : DEFAULT_DISTRIBUTOR_UP_NODE_STATE;
    }

    private void deserialize(String serialized) throws ParseException {
        StringTokenizer st = new StringTokenizer(serialized, " \t\n\f\r", false);
        NodeData nodeData = new NodeData();
        String lastAbsolutePath = "";
        this.state = State.UP;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int index = token.indexOf(58);
            if (index < 0) {
                throw new ParseException("Token " + token + " does not contain ':': " + serialized, 0);
            }
            Object key = token.substring(0, index);
            String value = token.substring(index + 1);
            if (((String)key).length() > 0 && ((String)key).charAt(0) == '.') {
                if (lastAbsolutePath.equals("")) {
                    throw new ParseException("The first path in system state string needs to be absolute, in state: " + serialized, 0);
                }
                key = lastAbsolutePath + (String)key;
            } else {
                lastAbsolutePath = key;
            }
            if (((String)key).length() > 0) {
                switch (((String)key).charAt(0)) {
                    case 'c': {
                        if (!((String)key).equals("cluster")) break;
                        this.setClusterState(State.get(value));
                        break;
                    }
                    case 'b': {
                        if (!((String)key).equals("bits")) break;
                        this.distributionBits = Integer.parseInt(value);
                        break;
                    }
                    case 'v': {
                        if (!((String)key).equals("version")) break;
                        try {
                            this.setVersion(Integer.valueOf(value));
                            break;
                        }
                        catch (Exception e) {
                            throw new ParseException("Illegal version '" + value + "'. Must be an integer, in state: " + serialized, 0);
                        }
                    }
                    case 'm': {
                        if (((String)key).length() > 1) break;
                        this.setDescription(StringUtilities.unescape((String)value));
                        break;
                    }
                    case 'd': 
                    case 's': {
                        Object type;
                        NodeType nodeType = null;
                        int dot = ((String)key).indexOf(46);
                        Object object = type = dot < 0 ? key : ((String)key).substring(0, dot);
                        if (((String)type).equals("storage")) {
                            nodeType = NodeType.STORAGE;
                        } else if (((String)type).equals("distributor")) {
                            nodeType = NodeType.DISTRIBUTOR;
                        }
                        if (nodeType == null) break;
                        if (dot < 0) {
                            int nodeCount;
                            try {
                                nodeCount = Integer.valueOf(value);
                            }
                            catch (Exception e) {
                                throw new ParseException("Illegal node count '" + value + "' in state: " + serialized, 0);
                            }
                            this.getNodes(nodeType).updateMaxIndex(nodeCount);
                            break;
                        }
                        int dot2 = ((String)key).indexOf(46, dot + 1);
                        Node node = dot2 < 0 ? new Node(nodeType, Integer.valueOf(((String)key).substring(dot + 1))) : new Node(nodeType, Integer.valueOf(((String)key).substring(dot + 1, dot2)));
                        if (node.getIndex() >= this.getNodeCount(nodeType)) {
                            throw new ParseException("Cannot index " + nodeType + " node " + node.getIndex() + " of " + this.getNodeCount(nodeType) + " in state: " + serialized, 0);
                        }
                        if (!nodeData.node.equals(node)) {
                            nodeData.addNodeState();
                        }
                        if (dot2 < 0) break;
                        nodeData.sb.append(' ').append(((String)key).substring(dot2 + 1)).append(':').append(value);
                        nodeData.node = node;
                        nodeData.empty = false;
                        break;
                    }
                }
            }
        }
        nodeData.addNodeState();
    }

    public String getTextualDifference(ClusterState other) {
        return this.getDiff(other).toString();
    }

    public String getHtmlDifference(ClusterState other) {
        return this.getDiff(other).toHtml();
    }

    private Diff getDiff(ClusterState other) {
        Diff diff = new Diff();
        if (this.version != other.version) {
            diff.add(new Diff.Entry("version", this.version, other.version));
        }
        if (!this.state.equals((Object)other.state)) {
            diff.add(new Diff.Entry("cluster", (Object)this.state, (Object)other.state));
        }
        if (this.distributionBits != other.distributionBits) {
            diff.add(new Diff.Entry("bits", this.distributionBits, other.distributionBits));
        }
        for (NodeType type : NodeType.getTypes()) {
            Diff typeDiff = new Diff();
            int maxCount = Math.max(this.getNodeCount(type), other.getNodeCount(type));
            for (int i = 0; i < maxCount; ++i) {
                Node n = new Node(type, i);
                Diff d = this.getNodeState(n).getDiff(other.getNodeState(n));
                if (!d.differs()) continue;
                typeDiff.add(new Diff.Entry(i, d));
            }
            if (!typeDiff.differs()) continue;
            diff.add(new Diff.Entry((Object)type, typeDiff).splitLine());
        }
        return diff;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getDistributionBitCount() {
        return this.distributionBits;
    }

    public void setDistributionBits(int bits) {
        this.distributionBits = bits;
    }

    public State getClusterState() {
        return this.state;
    }

    public void setClusterState(State s) {
        if (!s.validClusterState()) {
            throw new IllegalArgumentException("Illegal cluster state " + s);
        }
        this.state = s;
    }

    public int getNodeCount(NodeType type) {
        return this.getNodes(type).getLogicalNodeCount();
    }

    public NodeState getNodeState(Node node) {
        return this.getNodes(node.getType()).getNodeState(node.getIndex());
    }

    public void setNodeState(Node node, NodeState newState) {
        newState.verifyValidInSystemState(node.getType());
        this.getNodes(node.getType()).setNodeState(node, newState);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean verbose) {
        StringBuilder sb = new StringBuilder();
        if (this.version != 0) {
            sb.append(" version:").append(this.version);
        }
        if (!this.state.equals((Object)State.UP)) {
            sb.append(" cluster:").append(this.state.serialize());
        }
        if (this.distributionBits != 16) {
            sb.append(" bits:").append(this.distributionBits);
        }
        sb.append(this.distributorNodes.toString(verbose));
        sb.append(this.storageNodes.toString(verbose));
        if (sb.length() > 0) {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    private static class Nodes {
        private int logicalNodeCount;
        private final NodeType type;
        private final BitSet upNodes;
        private final Map<Integer, NodeState> nodeStates = new HashMap<Integer, NodeState>();

        Nodes(NodeType type) {
            this.type = type;
            this.upNodes = new BitSet();
        }

        Nodes(Nodes b) {
            this.logicalNodeCount = b.logicalNodeCount;
            this.type = b.type;
            this.upNodes = (BitSet)b.upNodes.clone();
            b.nodeStates.forEach((key, value) -> this.nodeStates.put((Integer)key, value.clone()));
        }

        void updateMaxIndex(int index) {
            if (index > this.logicalNodeCount) {
                this.upNodes.set(this.logicalNodeCount, index);
                this.logicalNodeCount = index;
            }
        }

        int getLogicalNodeCount() {
            return this.logicalNodeCount;
        }

        NodeState getNodeState(int index) {
            NodeState ns = this.nodeStates.get(index);
            if (ns != null) {
                return ns;
            }
            return index >= this.getLogicalNodeCount() || !this.upNodes.get(index) ? new NodeState(this.type, State.DOWN) : new NodeState(this.type, State.UP);
        }

        private void validateInput(Node node, NodeState ns) {
            ns.verifyValidInSystemState(node.getType());
            if (node.getType() != this.type) {
                throw new IllegalArgumentException("NodeType '" + node.getType() + "' differs from '" + this.type + "'");
            }
        }

        void setNodeState(Node node, NodeState ns) {
            this.validateInput(node, ns);
            int index = node.getIndex();
            if (index >= this.logicalNodeCount) {
                this.logicalNodeCount = index + 1;
            }
            this.setNodeStateInternal(index, ns);
        }

        void addNodeState(Node node, NodeState ns) {
            this.validateInput(node, ns);
            int index = node.getIndex();
            this.updateMaxIndex(index + 1);
            this.setNodeStateInternal(index, ns);
        }

        private static boolean equalsWithDescription(NodeState a, NodeState b) {
            return a.equals(b) && (a.getState() != State.DOWN || a.getDescription().equals(b.getDescription()));
        }

        private void setNodeStateInternal(int index, NodeState ns) {
            this.nodeStates.remove(index);
            if (ns.getState() == State.DOWN) {
                this.upNodes.clear(index);
                if (!Nodes.equalsWithDescription(this.defaultDown(), ns)) {
                    this.nodeStates.put(index, ns);
                }
            } else {
                this.upNodes.set(index);
                if (!Nodes.equalsWithDescription(this.defaultUp(), ns)) {
                    this.nodeStates.put(index, ns);
                }
            }
        }

        boolean similarToImpl(Nodes other, NodeStateCmp nodeStateCmp) {
            if (this.logicalNodeCount != other.logicalNodeCount) {
                return false;
            }
            if (this.type != other.type) {
                return false;
            }
            if (!this.upNodes.equals(other.upNodes)) {
                return false;
            }
            for (Integer node : this.unionNodeSetWith(other.nodeStates.keySet())) {
                NodeState rhs;
                NodeState lhs = this.nodeStates.get(node);
                if (nodeStateCmp.similar(this.type, lhs, rhs = other.nodeStates.get(node))) continue;
                return false;
            }
            return true;
        }

        private Set<Integer> unionNodeSetWith(Set<Integer> otherNodes) {
            HashSet<Integer> unionNodeSet = new HashSet<Integer>(this.nodeStates.keySet());
            unionNodeSet.addAll(otherNodes);
            return unionNodeSet;
        }

        public String toString() {
            return this.toString(false);
        }

        String toString(boolean verbose) {
            int nodeCount;
            StringBuilder sb = new StringBuilder();
            int n = nodeCount = verbose ? this.getLogicalNodeCount() : this.upNodes.length();
            if (nodeCount > 0) {
                sb.append(this.type == NodeType.DISTRIBUTOR ? " distributor:" : " storage:").append(nodeCount);
                for (int i = 0; i < nodeCount; ++i) {
                    String nodeState = this.getNodeState(i).serialize(i, verbose);
                    if (nodeState.isEmpty()) continue;
                    sb.append(' ').append(nodeState);
                }
            }
            return sb.toString();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Nodes)) {
                return false;
            }
            Nodes b = (Nodes)obj;
            if (this.logicalNodeCount != b.logicalNodeCount) {
                return false;
            }
            if (this.type != b.type) {
                return false;
            }
            if (!this.upNodes.equals(b.upNodes)) {
                return false;
            }
            return this.nodeStates.equals(b.nodeStates);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.logicalNodeCount, this.type, this.nodeStates, this.upNodes});
        }

        private NodeState defaultDown() {
            return this.type == NodeType.STORAGE ? DEFAULT_STORAGE_DOWN_NODE_STATE : DEFAULT_DISTRIBUTOR_DOWN_NODE_STATE;
        }

        private NodeState defaultUp() {
            return ClusterState.defaultUpNodeState(this.type);
        }
    }

    @FunctionalInterface
    private static interface NodeStateCmp {
        public boolean similar(NodeType var1, NodeState var2, NodeState var3);
    }

    private class NodeData {
        boolean empty = true;
        Node node = new Node(NodeType.STORAGE, 0);
        StringBuilder sb = new StringBuilder();

        private NodeData() {
        }

        void addNodeState() throws ParseException {
            if (!this.empty) {
                NodeState ns = NodeState.deserialize(this.node.getType(), this.sb.toString());
                ClusterState.this.getNodes(this.node.getType()).addNodeState(this.node, ns);
            }
            this.empty = true;
            this.sb = new StringBuilder();
        }
    }
}

