/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.test;

import com.yahoo.component.annotation.Inject;
import java.time.Clock;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAmount;
import java.util.concurrent.atomic.AtomicReference;

public class ManualClock
extends Clock {
    private final AtomicReference<Instant> currentTime = new AtomicReference<Instant>(Instant.now());

    @Inject
    public ManualClock() {
    }

    public ManualClock(String utcIsoTime) {
        this(ManualClock.at(utcIsoTime));
    }

    public ManualClock(Instant currentTime) {
        this.setInstant(currentTime);
    }

    public void advance(TemporalAmount temporal) {
        this.currentTime.updateAndGet(time -> time.plus(temporal));
    }

    public void retreat(TemporalAmount temporal) {
        this.currentTime.updateAndGet(time -> time.minus(temporal));
    }

    public void setInstant(Instant time) {
        this.currentTime.set(time);
    }

    @Override
    public Instant instant() {
        return this.currentTime.get();
    }

    @Override
    public ZoneId getZone() {
        return ZoneOffset.UTC;
    }

    @Override
    public Clock withZone(ZoneId zone) {
        return this;
    }

    @Override
    public long millis() {
        return this.instant().toEpochMilli();
    }

    public static Instant at(String utcIsoTime) {
        return LocalDateTime.parse(utcIsoTime, DateTimeFormatter.ISO_DATE_TIME).atZone(ZoneOffset.UTC).toInstant();
    }

    public String toString() {
        return "ManualClock{currentTime=" + this.currentTime + "}";
    }
}

