/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.test;

import java.lang.reflect.Method;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public final class Matchers {
    public static Matcher<Iterable> hasItemWithMethod(Object expected, String methodName) {
        return Matchers.hasItemWithMethod(new MethodResult(methodName, expected));
    }

    public static Matcher<Iterable> hasItemWithMethod(final MethodResult ... results) {
        return new BaseMatcher<Iterable>(){

            public boolean matches(Object item) {
                Iterable components = (Iterable)item;
                if (!components.iterator().hasNext()) {
                    return false;
                }
                for (Object componentInList : components) {
                    boolean allMethodsMatch = false;
                    for (MethodResult result : results) {
                        Object strToMatch;
                        try {
                            Method method = componentInList.getClass().getMethod(result.getMethodName(), new Class[0]);
                            strToMatch = method.invoke(componentInList, new Object[0]);
                        }
                        catch (Exception e) {
                            allMethodsMatch = false;
                            break;
                        }
                        if (!result.getExpectedResult().equals(strToMatch)) {
                            allMethodsMatch = false;
                            break;
                        }
                        allMethodsMatch = true;
                    }
                    if (!allMethodsMatch) continue;
                    return true;
                }
                return false;
            }

            public void describeTo(Description description) {
                StringBuilder b = new StringBuilder();
                for (MethodResult result : results) {
                    b.append(result).append(". ");
                }
                description.appendText(b.toString());
            }
        };
    }

    public static final class MethodResult {
        private final String methodName;
        private final Object expectedResult;

        public MethodResult(String methodName, Object expectedResult) {
            this.methodName = methodName;
            this.expectedResult = expectedResult;
        }

        public Object getExpectedResult() {
            return this.expectedResult;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public String toString() {
            return "Method: '" + this.methodName + "', expected result: '" + String.valueOf(this.expectedResult) + "'";
        }
    }
}

