/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.test.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.yahoo.test.json.JsonBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

class JsonNodeFormatter {
    private final JsonBuilder builder;

    static String toNormalizedJson(JsonNode jsonNode, boolean compact) {
        JsonNodeFormatter formatter = new JsonNodeFormatter(compact);
        formatter.appendValue(jsonNode);
        return formatter.toString();
    }

    private JsonNodeFormatter(boolean compact) {
        this.builder = compact ? JsonBuilder.forCompactJson() : JsonBuilder.forMultiLineJson(2);
    }

    private void appendValue(JsonNode jsonNode) {
        switch (jsonNode.getNodeType()) {
            case OBJECT: {
                ObjectNode objectNode = (ObjectNode)jsonNode;
                ArrayList fieldNames = new ArrayList();
                objectNode.fieldNames().forEachRemaining(fieldNames::add);
                Collections.sort(fieldNames);
                if (fieldNames.isEmpty()) {
                    this.builder.append("{}");
                    break;
                }
                boolean firstIteration = true;
                for (String fieldName : fieldNames) {
                    if (firstIteration) {
                        this.builder.appendLineAndIndent("{", 1);
                        firstIteration = false;
                    } else {
                        this.builder.appendLineAndIndent(",");
                    }
                    this.builder.appendStringValue(fieldName);
                    this.builder.appendColon();
                    this.appendValue(objectNode.get(fieldName));
                }
                this.builder.newLineIndentAndAppend(-1, "}");
                break;
            }
            case ARRAY: {
                Iterator elements = jsonNode.elements();
                if (elements.hasNext()) {
                    this.builder.appendLineAndIndent("[", 1);
                    this.appendValue((JsonNode)elements.next());
                    while (elements.hasNext()) {
                        this.builder.appendLineAndIndent(",");
                        this.appendValue((JsonNode)elements.next());
                    }
                    this.builder.newLineIndentAndAppend(-1, "]");
                    break;
                }
                this.builder.append("[]");
                break;
            }
            case BOOLEAN: 
            case NUMBER: 
            case NULL: {
                this.builder.append(jsonNode.asText());
                break;
            }
            case STRING: {
                this.builder.appendStringValue(jsonNode.asText());
                break;
            }
            case BINARY: 
            case MISSING: 
            case POJO: {
                throw new IllegalStateException(jsonNode.getNodeType().toString());
            }
        }
    }

    public String toString() {
        return this.builder.toString();
    }
}

