/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.test.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import uk.co.datumedge.hamcrest.json.SameJSONAs;

public class JsonTestHelper {
    private static final ObjectMapper mapper = new ObjectMapper();

    public static String inputJson(String ... lines) {
        return Joiner.on((String)"\n").join((Object[])lines).replaceAll("'", "\"");
    }

    public static void assertJsonEquals(String inputJson, String expectedJson) {
        MatcherAssert.assertThat((Object)inputJson, (Matcher)SameJSONAs.sameJSONAs((String)expectedJson));
    }

    public static void assertJsonEquals(JsonNode left, String rightJson) {
        try {
            String leftJson = mapper.writeValueAsString((Object)left);
            JsonTestHelper.assertJsonEquals(leftJson, rightJson);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public static void assertJsonEquals(JsonNode left, JsonNode right) {
        try {
            String leftJson = mapper.writeValueAsString((Object)left);
            String rightJson = mapper.writeValueAsString((Object)right);
            JsonTestHelper.assertJsonEquals(leftJson, rightJson);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }
}

