/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.test;

import com.google.inject.Inject;
import java.time.Clock;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAmount;

public class ManualClock
extends Clock {
    private Instant currentTime = Instant.now();

    @Inject
    public ManualClock() {
    }

    public ManualClock(String utcIsoTime) {
        this(ManualClock.at(utcIsoTime));
    }

    public ManualClock(Instant currentTime) {
        this.currentTime = currentTime;
    }

    public void advance(TemporalAmount temporal) {
        this.currentTime = this.currentTime.plus(temporal);
    }

    public void setInstant(Instant time) {
        this.currentTime = time;
    }

    @Override
    public Instant instant() {
        return this.currentTime;
    }

    @Override
    public ZoneId getZone() {
        return null;
    }

    @Override
    public Clock withZone(ZoneId zone) {
        return null;
    }

    @Override
    public long millis() {
        return this.currentTime.toEpochMilli();
    }

    public static Instant at(String utcIsoTime) {
        return LocalDateTime.parse(utcIsoTime, DateTimeFormatter.ISO_DATE_TIME).atZone(ZoneOffset.UTC).toInstant();
    }
}

