/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.hosted.cd;

import ai.vespa.cloud.ApplicationId;
import ai.vespa.cloud.Zone;
import ai.vespa.hosted.cd.Deployment;
import ai.vespa.hosted.cd.internal.TestRuntimeProvider;
import java.util.ServiceLoader;
import java.util.logging.Logger;

public interface TestRuntime {
    public static final Logger logger = Logger.getLogger(TestRuntime.class.getName());

    public static TestRuntime get() {
        TestRuntime provided = TestRuntimeProvider.getTestRuntime();
        if (provided != null) {
            logger.fine("Using test runtime from TestRuntimeProvider");
            return provided;
        }
        logger.fine("Using test runtime from ServiceLoader");
        return ServiceLoader.load(TestRuntime.class, TestRuntime.class.getClassLoader()).findFirst().orElseThrow(() -> new IllegalStateException("No TestRuntime initialized"));
    }

    public Deployment deploymentToTest();

    public Zone zone();

    public ApplicationId application();
}

