/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.content.core;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.Node;
import com.yahoo.config.StringNode;
import java.util.HashSet;
import java.util.Set;

public final class RpcProviderConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "e0c721199ca1c8a9aef454289df8eab2";
    public static final String CONFIG_DEF_NAME = "rpc-provider";
    public static final String CONFIG_DEF_NAMESPACE = "vespa.config.content.core";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=vespa.config.content.core", "connectspec string default=\"tcp/localhost:17777\" restart"};
    private final StringNode connectspec;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public RpcProviderConfig(Builder builder) {
        this(builder, true);
    }

    private RpcProviderConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for rpc-provider must be initialized: " + builder.__uninitialized);
        }
        this.connectspec = builder.connectspec == null ? new StringNode("tcp/localhost:17777") : new StringNode(builder.connectspec);
    }

    public String connectspec() {
        return this.connectspec.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(RpcProviderConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        changes.compare((Node)this.connectspec, (Node)newConfig.connectspec, "connectspec", "");
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return true;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private String connectspec = null;
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(RpcProviderConfig config) {
            this.connectspec(config.connectspec());
        }

        private Builder override(Builder __superior) {
            if (__superior.connectspec != null) {
                this.connectspec(__superior.connectspec);
            }
            return this;
        }

        public Builder connectspec(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.connectspec = __value;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return RpcProviderConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return RpcProviderConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return RpcProviderConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public RpcProviderConfig build() {
            return new RpcProviderConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

