/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.content.core;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.EnumNode;
import com.yahoo.config.InnerNode;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.LeafNode;
import com.yahoo.config.LeafNodeVector;
import com.yahoo.config.Node;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class StorDistributormanagerConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "5cb932f581cddbdc58ce5a6e7bfb5d33";
    public static final String CONFIG_DEF_NAME = "stor-distributormanager";
    public static final String CONFIG_DEF_NAMESPACE = "vespa.config.content.core";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=vespa.config.content.core", "maxpendingidealstateoperations int default=100", "splitsize int default=33544432", "splitcount int default=1024", "joinsize int default=16000000", "joincount int default=512", "minsplitcount int default=16", "garbagecollection.selectiontoremove string default=\"\"", "garbagecollection.interval int default=0", "inlinebucketsplitting bool default=true", "blockedstatecheckers[] string restart", "enable_revert bool default=true", "maximum_nodes_per_merge int default=16", "start_distributor_thread bool default=true restart", "ticks_before_wait int default=10", "ticks_wait_time_ms int default=1", "max_process_time_ms int default=5000", "priority_merge_move_to_ideal_node int default=165", "priority_merge_out_of_sync_copies int default=120", "priority_merge_too_few_copies int default=120", "priority_activate_no_existing_active int default=100", "priority_activate_with_existing_active int default=100", "priority_delete_bucket_copy int default=100", "priority_join_buckets int default=155", "priority_split_distribution_bits int default=200", "priority_split_large_bucket int default=175", "priority_split_inconsistent_bucket int default=110", "priority_garbage_collection int default=200", "enable_join_for_sibling_less_buckets bool default=false", "enable_inconsistent_join bool default=false", "enable_host_info_reporting bool default=true", "minimum_replica_counting_mode enum { TRUSTED, ANY } default=TRUSTED", "disable_bucket_activation bool default=false", "max_cluster_clock_skew_sec int default=1", "sequence_mutating_operations bool default=true", "inhibit_merge_sending_on_busy_node_duration_sec int default=10", "allow_stale_reads_during_cluster_state_transitions bool default=false", "simulated_db_pruning_latency_msec int default=0", "simulated_db_merging_latency_msec int default=0", "use_btree_database bool default=true restart", "restart_with_fast_update_path_if_all_get_timestamps_are_consistent bool default=false", "merge_operations_disabled bool default=false", "use_weak_internal_read_consistency_for_client_gets bool default=false", "enable_metadata_only_fetch_phase_for_inconsistent_updates bool default=false", "max_consecutively_inhibited_maintenance_ticks int default=20"};
    private final IntegerNode maxpendingidealstateoperations;
    private final IntegerNode splitsize;
    private final IntegerNode splitcount;
    private final IntegerNode joinsize;
    private final IntegerNode joincount;
    private final IntegerNode minsplitcount;
    private final Garbagecollection garbagecollection;
    private final BooleanNode inlinebucketsplitting;
    private final LeafNodeVector<String, StringNode> blockedstatecheckers;
    private final BooleanNode enable_revert;
    private final IntegerNode maximum_nodes_per_merge;
    private final BooleanNode start_distributor_thread;
    private final IntegerNode ticks_before_wait;
    private final IntegerNode ticks_wait_time_ms;
    private final IntegerNode max_process_time_ms;
    private final IntegerNode priority_merge_move_to_ideal_node;
    private final IntegerNode priority_merge_out_of_sync_copies;
    private final IntegerNode priority_merge_too_few_copies;
    private final IntegerNode priority_activate_no_existing_active;
    private final IntegerNode priority_activate_with_existing_active;
    private final IntegerNode priority_delete_bucket_copy;
    private final IntegerNode priority_join_buckets;
    private final IntegerNode priority_split_distribution_bits;
    private final IntegerNode priority_split_large_bucket;
    private final IntegerNode priority_split_inconsistent_bucket;
    private final IntegerNode priority_garbage_collection;
    private final BooleanNode enable_join_for_sibling_less_buckets;
    private final BooleanNode enable_inconsistent_join;
    private final BooleanNode enable_host_info_reporting;
    private final Minimum_replica_counting_mode minimum_replica_counting_mode;
    private final BooleanNode disable_bucket_activation;
    private final IntegerNode max_cluster_clock_skew_sec;
    private final BooleanNode sequence_mutating_operations;
    private final IntegerNode inhibit_merge_sending_on_busy_node_duration_sec;
    private final BooleanNode allow_stale_reads_during_cluster_state_transitions;
    private final IntegerNode simulated_db_pruning_latency_msec;
    private final IntegerNode simulated_db_merging_latency_msec;
    private final BooleanNode use_btree_database;
    private final BooleanNode restart_with_fast_update_path_if_all_get_timestamps_are_consistent;
    private final BooleanNode merge_operations_disabled;
    private final BooleanNode use_weak_internal_read_consistency_for_client_gets;
    private final BooleanNode enable_metadata_only_fetch_phase_for_inconsistent_updates;
    private final IntegerNode max_consecutively_inhibited_maintenance_ticks;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public StorDistributormanagerConfig(Builder builder) {
        this(builder, true);
    }

    private StorDistributormanagerConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for stor-distributormanager must be initialized: " + builder.__uninitialized);
        }
        this.maxpendingidealstateoperations = builder.maxpendingidealstateoperations == null ? new IntegerNode(100) : new IntegerNode(builder.maxpendingidealstateoperations.intValue());
        this.splitsize = builder.splitsize == null ? new IntegerNode(33544432) : new IntegerNode(builder.splitsize.intValue());
        this.splitcount = builder.splitcount == null ? new IntegerNode(1024) : new IntegerNode(builder.splitcount.intValue());
        this.joinsize = builder.joinsize == null ? new IntegerNode(16000000) : new IntegerNode(builder.joinsize.intValue());
        this.joincount = builder.joincount == null ? new IntegerNode(512) : new IntegerNode(builder.joincount.intValue());
        this.minsplitcount = builder.minsplitcount == null ? new IntegerNode(16) : new IntegerNode(builder.minsplitcount.intValue());
        this.garbagecollection = new Garbagecollection(builder.garbagecollection, throwIfUninitialized);
        this.inlinebucketsplitting = builder.inlinebucketsplitting == null ? new BooleanNode(true) : new BooleanNode(builder.inlinebucketsplitting.booleanValue());
        this.blockedstatecheckers = new LeafNodeVector(builder.blockedstatecheckers, (LeafNode)new StringNode());
        this.enable_revert = builder.enable_revert == null ? new BooleanNode(true) : new BooleanNode(builder.enable_revert.booleanValue());
        this.maximum_nodes_per_merge = builder.maximum_nodes_per_merge == null ? new IntegerNode(16) : new IntegerNode(builder.maximum_nodes_per_merge.intValue());
        this.start_distributor_thread = builder.start_distributor_thread == null ? new BooleanNode(true) : new BooleanNode(builder.start_distributor_thread.booleanValue());
        this.ticks_before_wait = builder.ticks_before_wait == null ? new IntegerNode(10) : new IntegerNode(builder.ticks_before_wait.intValue());
        this.ticks_wait_time_ms = builder.ticks_wait_time_ms == null ? new IntegerNode(1) : new IntegerNode(builder.ticks_wait_time_ms.intValue());
        this.max_process_time_ms = builder.max_process_time_ms == null ? new IntegerNode(5000) : new IntegerNode(builder.max_process_time_ms.intValue());
        this.priority_merge_move_to_ideal_node = builder.priority_merge_move_to_ideal_node == null ? new IntegerNode(165) : new IntegerNode(builder.priority_merge_move_to_ideal_node.intValue());
        this.priority_merge_out_of_sync_copies = builder.priority_merge_out_of_sync_copies == null ? new IntegerNode(120) : new IntegerNode(builder.priority_merge_out_of_sync_copies.intValue());
        this.priority_merge_too_few_copies = builder.priority_merge_too_few_copies == null ? new IntegerNode(120) : new IntegerNode(builder.priority_merge_too_few_copies.intValue());
        this.priority_activate_no_existing_active = builder.priority_activate_no_existing_active == null ? new IntegerNode(100) : new IntegerNode(builder.priority_activate_no_existing_active.intValue());
        this.priority_activate_with_existing_active = builder.priority_activate_with_existing_active == null ? new IntegerNode(100) : new IntegerNode(builder.priority_activate_with_existing_active.intValue());
        this.priority_delete_bucket_copy = builder.priority_delete_bucket_copy == null ? new IntegerNode(100) : new IntegerNode(builder.priority_delete_bucket_copy.intValue());
        this.priority_join_buckets = builder.priority_join_buckets == null ? new IntegerNode(155) : new IntegerNode(builder.priority_join_buckets.intValue());
        this.priority_split_distribution_bits = builder.priority_split_distribution_bits == null ? new IntegerNode(200) : new IntegerNode(builder.priority_split_distribution_bits.intValue());
        this.priority_split_large_bucket = builder.priority_split_large_bucket == null ? new IntegerNode(175) : new IntegerNode(builder.priority_split_large_bucket.intValue());
        this.priority_split_inconsistent_bucket = builder.priority_split_inconsistent_bucket == null ? new IntegerNode(110) : new IntegerNode(builder.priority_split_inconsistent_bucket.intValue());
        this.priority_garbage_collection = builder.priority_garbage_collection == null ? new IntegerNode(200) : new IntegerNode(builder.priority_garbage_collection.intValue());
        this.enable_join_for_sibling_less_buckets = builder.enable_join_for_sibling_less_buckets == null ? new BooleanNode(false) : new BooleanNode(builder.enable_join_for_sibling_less_buckets.booleanValue());
        this.enable_inconsistent_join = builder.enable_inconsistent_join == null ? new BooleanNode(false) : new BooleanNode(builder.enable_inconsistent_join.booleanValue());
        this.enable_host_info_reporting = builder.enable_host_info_reporting == null ? new BooleanNode(true) : new BooleanNode(builder.enable_host_info_reporting.booleanValue());
        this.minimum_replica_counting_mode = builder.minimum_replica_counting_mode == null ? new Minimum_replica_counting_mode(Minimum_replica_counting_mode.TRUSTED) : new Minimum_replica_counting_mode(builder.minimum_replica_counting_mode);
        this.disable_bucket_activation = builder.disable_bucket_activation == null ? new BooleanNode(false) : new BooleanNode(builder.disable_bucket_activation.booleanValue());
        this.max_cluster_clock_skew_sec = builder.max_cluster_clock_skew_sec == null ? new IntegerNode(1) : new IntegerNode(builder.max_cluster_clock_skew_sec.intValue());
        this.sequence_mutating_operations = builder.sequence_mutating_operations == null ? new BooleanNode(true) : new BooleanNode(builder.sequence_mutating_operations.booleanValue());
        this.inhibit_merge_sending_on_busy_node_duration_sec = builder.inhibit_merge_sending_on_busy_node_duration_sec == null ? new IntegerNode(10) : new IntegerNode(builder.inhibit_merge_sending_on_busy_node_duration_sec.intValue());
        this.allow_stale_reads_during_cluster_state_transitions = builder.allow_stale_reads_during_cluster_state_transitions == null ? new BooleanNode(false) : new BooleanNode(builder.allow_stale_reads_during_cluster_state_transitions.booleanValue());
        this.simulated_db_pruning_latency_msec = builder.simulated_db_pruning_latency_msec == null ? new IntegerNode(0) : new IntegerNode(builder.simulated_db_pruning_latency_msec.intValue());
        this.simulated_db_merging_latency_msec = builder.simulated_db_merging_latency_msec == null ? new IntegerNode(0) : new IntegerNode(builder.simulated_db_merging_latency_msec.intValue());
        this.use_btree_database = builder.use_btree_database == null ? new BooleanNode(true) : new BooleanNode(builder.use_btree_database.booleanValue());
        this.restart_with_fast_update_path_if_all_get_timestamps_are_consistent = builder.restart_with_fast_update_path_if_all_get_timestamps_are_consistent == null ? new BooleanNode(false) : new BooleanNode(builder.restart_with_fast_update_path_if_all_get_timestamps_are_consistent.booleanValue());
        this.merge_operations_disabled = builder.merge_operations_disabled == null ? new BooleanNode(false) : new BooleanNode(builder.merge_operations_disabled.booleanValue());
        this.use_weak_internal_read_consistency_for_client_gets = builder.use_weak_internal_read_consistency_for_client_gets == null ? new BooleanNode(false) : new BooleanNode(builder.use_weak_internal_read_consistency_for_client_gets.booleanValue());
        this.enable_metadata_only_fetch_phase_for_inconsistent_updates = builder.enable_metadata_only_fetch_phase_for_inconsistent_updates == null ? new BooleanNode(false) : new BooleanNode(builder.enable_metadata_only_fetch_phase_for_inconsistent_updates.booleanValue());
        this.max_consecutively_inhibited_maintenance_ticks = builder.max_consecutively_inhibited_maintenance_ticks == null ? new IntegerNode(20) : new IntegerNode(builder.max_consecutively_inhibited_maintenance_ticks.intValue());
    }

    public int maxpendingidealstateoperations() {
        return this.maxpendingidealstateoperations.value();
    }

    public int splitsize() {
        return this.splitsize.value();
    }

    public int splitcount() {
        return this.splitcount.value();
    }

    public int joinsize() {
        return this.joinsize.value();
    }

    public int joincount() {
        return this.joincount.value();
    }

    public int minsplitcount() {
        return this.minsplitcount.value();
    }

    public Garbagecollection garbagecollection() {
        return this.garbagecollection;
    }

    public boolean inlinebucketsplitting() {
        return this.inlinebucketsplitting.value();
    }

    public List<String> blockedstatecheckers() {
        return this.blockedstatecheckers.asList();
    }

    public String blockedstatecheckers(int i) {
        return ((StringNode)this.blockedstatecheckers.get(i)).value();
    }

    public boolean enable_revert() {
        return this.enable_revert.value();
    }

    public int maximum_nodes_per_merge() {
        return this.maximum_nodes_per_merge.value();
    }

    public boolean start_distributor_thread() {
        return this.start_distributor_thread.value();
    }

    public int ticks_before_wait() {
        return this.ticks_before_wait.value();
    }

    public int ticks_wait_time_ms() {
        return this.ticks_wait_time_ms.value();
    }

    public int max_process_time_ms() {
        return this.max_process_time_ms.value();
    }

    public int priority_merge_move_to_ideal_node() {
        return this.priority_merge_move_to_ideal_node.value();
    }

    public int priority_merge_out_of_sync_copies() {
        return this.priority_merge_out_of_sync_copies.value();
    }

    public int priority_merge_too_few_copies() {
        return this.priority_merge_too_few_copies.value();
    }

    public int priority_activate_no_existing_active() {
        return this.priority_activate_no_existing_active.value();
    }

    public int priority_activate_with_existing_active() {
        return this.priority_activate_with_existing_active.value();
    }

    public int priority_delete_bucket_copy() {
        return this.priority_delete_bucket_copy.value();
    }

    public int priority_join_buckets() {
        return this.priority_join_buckets.value();
    }

    public int priority_split_distribution_bits() {
        return this.priority_split_distribution_bits.value();
    }

    public int priority_split_large_bucket() {
        return this.priority_split_large_bucket.value();
    }

    public int priority_split_inconsistent_bucket() {
        return this.priority_split_inconsistent_bucket.value();
    }

    public int priority_garbage_collection() {
        return this.priority_garbage_collection.value();
    }

    public boolean enable_join_for_sibling_less_buckets() {
        return this.enable_join_for_sibling_less_buckets.value();
    }

    public boolean enable_inconsistent_join() {
        return this.enable_inconsistent_join.value();
    }

    public boolean enable_host_info_reporting() {
        return this.enable_host_info_reporting.value();
    }

    public Minimum_replica_counting_mode.Enum minimum_replica_counting_mode() {
        return (Minimum_replica_counting_mode.Enum)((Object)this.minimum_replica_counting_mode.value());
    }

    public boolean disable_bucket_activation() {
        return this.disable_bucket_activation.value();
    }

    public int max_cluster_clock_skew_sec() {
        return this.max_cluster_clock_skew_sec.value();
    }

    public boolean sequence_mutating_operations() {
        return this.sequence_mutating_operations.value();
    }

    public int inhibit_merge_sending_on_busy_node_duration_sec() {
        return this.inhibit_merge_sending_on_busy_node_duration_sec.value();
    }

    public boolean allow_stale_reads_during_cluster_state_transitions() {
        return this.allow_stale_reads_during_cluster_state_transitions.value();
    }

    public int simulated_db_pruning_latency_msec() {
        return this.simulated_db_pruning_latency_msec.value();
    }

    public int simulated_db_merging_latency_msec() {
        return this.simulated_db_merging_latency_msec.value();
    }

    public boolean use_btree_database() {
        return this.use_btree_database.value();
    }

    public boolean restart_with_fast_update_path_if_all_get_timestamps_are_consistent() {
        return this.restart_with_fast_update_path_if_all_get_timestamps_are_consistent.value();
    }

    public boolean merge_operations_disabled() {
        return this.merge_operations_disabled.value();
    }

    public boolean use_weak_internal_read_consistency_for_client_gets() {
        return this.use_weak_internal_read_consistency_for_client_gets.value();
    }

    public boolean enable_metadata_only_fetch_phase_for_inconsistent_updates() {
        return this.enable_metadata_only_fetch_phase_for_inconsistent_updates.value();
    }

    public int max_consecutively_inhibited_maintenance_ticks() {
        return this.max_consecutively_inhibited_maintenance_ticks.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(StorDistributormanagerConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        changes.compareArray(this.blockedstatecheckers, newConfig.blockedstatecheckers, "blockedstatecheckers", "List of state checkers (ideal state generators) that should be ignored in the cluster.\nOne or more of the following (case insensitive):\n \nSynchronizeAndMove\nDeleteExtraCopies\nJoinBuckets\nSplitBucket\nSplitInconsistentBuckets\nSetBucketState\nGarbageCollection", (a, b) -> new ChangesRequiringRestart("blockedstatecheckers").compare(a, b, CONFIG_DEF_VERSION, "List of state checkers (ideal state generators) that should be ignored in the cluster.\nOne or more of the following (case insensitive):\n \nSynchronizeAndMove\nDeleteExtraCopies\nJoinBuckets\nSplitBucket\nSplitInconsistentBuckets\nSetBucketState\nGarbageCollection"));
        changes.compare((Node)this.start_distributor_thread, (Node)newConfig.start_distributor_thread, "start_distributor_thread", "For internal in process debugging, it may be useful to not start the\ndistributor thread to be able to call tick() manually and run single threaded");
        changes.compare((Node)this.use_btree_database, (Node)newConfig.use_btree_database, "use_btree_database", "Whether to use a B-tree data structure for the distributor bucket database instead\nof the legacy database. Setting this option may trigger alternate code paths for\nread only operations, as the B-tree database is thread safe for concurrent reads.");
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return true;
    }

    public static final class Minimum_replica_counting_mode
    extends EnumNode<Enum> {
        public static final Enum TRUSTED = Enum.TRUSTED;
        public static final Enum ANY = Enum.ANY;

        public Minimum_replica_counting_mode() {
            this.value = null;
        }

        public Minimum_replica_counting_mode(Enum enumValue) {
            super(enumValue != null);
            this.value = enumValue;
        }

        protected boolean doSetValue(String name) {
            try {
                this.value = Enum.valueOf(name);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        public static enum Enum {
            TRUSTED,
            ANY;

        }
    }

    public static final class Garbagecollection
    extends InnerNode {
        private final StringNode selectiontoremove;
        private final IntegerNode interval;

        public Garbagecollection(Builder builder) {
            this(builder, true);
        }

        private Garbagecollection(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for stor-distributormanager.garbagecollection must be initialized: " + builder.__uninitialized);
            }
            this.selectiontoremove = builder.selectiontoremove == null ? new StringNode(StorDistributormanagerConfig.CONFIG_DEF_VERSION) : new StringNode(builder.selectiontoremove);
            this.interval = builder.interval == null ? new IntegerNode(0) : new IntegerNode(builder.interval.intValue());
        }

        public String selectiontoremove() {
            return this.selectiontoremove.value();
        }

        public int interval() {
            return this.interval.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Garbagecollection newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("garbagecollection");
            return changes;
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private String selectiontoremove = null;
            private Integer interval = null;

            public Builder() {
            }

            public Builder(Garbagecollection config) {
                this.selectiontoremove(config.selectiontoremove());
                this.interval(config.interval());
            }

            private Builder override(Builder __superior) {
                if (__superior.selectiontoremove != null) {
                    this.selectiontoremove(__superior.selectiontoremove);
                }
                if (__superior.interval != null) {
                    this.interval(__superior.interval);
                }
                return this;
            }

            public Builder selectiontoremove(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.selectiontoremove = __value;
                return this;
            }

            public Builder interval(int __value) {
                this.interval = __value;
                return this;
            }

            private Builder interval(String __value) {
                return this.interval(Integer.valueOf(__value));
            }

            public Garbagecollection build() {
                return new Garbagecollection(this);
            }
        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private Integer maxpendingidealstateoperations = null;
        private Integer splitsize = null;
        private Integer splitcount = null;
        private Integer joinsize = null;
        private Integer joincount = null;
        private Integer minsplitcount = null;
        public Garbagecollection.Builder garbagecollection = new Garbagecollection.Builder();
        private Boolean inlinebucketsplitting = null;
        public List<String> blockedstatecheckers = new ArrayList<String>();
        private Boolean enable_revert = null;
        private Integer maximum_nodes_per_merge = null;
        private Boolean start_distributor_thread = null;
        private Integer ticks_before_wait = null;
        private Integer ticks_wait_time_ms = null;
        private Integer max_process_time_ms = null;
        private Integer priority_merge_move_to_ideal_node = null;
        private Integer priority_merge_out_of_sync_copies = null;
        private Integer priority_merge_too_few_copies = null;
        private Integer priority_activate_no_existing_active = null;
        private Integer priority_activate_with_existing_active = null;
        private Integer priority_delete_bucket_copy = null;
        private Integer priority_join_buckets = null;
        private Integer priority_split_distribution_bits = null;
        private Integer priority_split_large_bucket = null;
        private Integer priority_split_inconsistent_bucket = null;
        private Integer priority_garbage_collection = null;
        private Boolean enable_join_for_sibling_less_buckets = null;
        private Boolean enable_inconsistent_join = null;
        private Boolean enable_host_info_reporting = null;
        private Minimum_replica_counting_mode.Enum minimum_replica_counting_mode = null;
        private Boolean disable_bucket_activation = null;
        private Integer max_cluster_clock_skew_sec = null;
        private Boolean sequence_mutating_operations = null;
        private Integer inhibit_merge_sending_on_busy_node_duration_sec = null;
        private Boolean allow_stale_reads_during_cluster_state_transitions = null;
        private Integer simulated_db_pruning_latency_msec = null;
        private Integer simulated_db_merging_latency_msec = null;
        private Boolean use_btree_database = null;
        private Boolean restart_with_fast_update_path_if_all_get_timestamps_are_consistent = null;
        private Boolean merge_operations_disabled = null;
        private Boolean use_weak_internal_read_consistency_for_client_gets = null;
        private Boolean enable_metadata_only_fetch_phase_for_inconsistent_updates = null;
        private Integer max_consecutively_inhibited_maintenance_ticks = null;

        public Builder() {
        }

        public Builder(StorDistributormanagerConfig config) {
            this.maxpendingidealstateoperations(config.maxpendingidealstateoperations());
            this.splitsize(config.splitsize());
            this.splitcount(config.splitcount());
            this.joinsize(config.joinsize());
            this.joincount(config.joincount());
            this.minsplitcount(config.minsplitcount());
            this.garbagecollection(new Garbagecollection.Builder(config.garbagecollection()));
            this.inlinebucketsplitting(config.inlinebucketsplitting());
            this.blockedstatecheckers(config.blockedstatecheckers());
            this.enable_revert(config.enable_revert());
            this.maximum_nodes_per_merge(config.maximum_nodes_per_merge());
            this.start_distributor_thread(config.start_distributor_thread());
            this.ticks_before_wait(config.ticks_before_wait());
            this.ticks_wait_time_ms(config.ticks_wait_time_ms());
            this.max_process_time_ms(config.max_process_time_ms());
            this.priority_merge_move_to_ideal_node(config.priority_merge_move_to_ideal_node());
            this.priority_merge_out_of_sync_copies(config.priority_merge_out_of_sync_copies());
            this.priority_merge_too_few_copies(config.priority_merge_too_few_copies());
            this.priority_activate_no_existing_active(config.priority_activate_no_existing_active());
            this.priority_activate_with_existing_active(config.priority_activate_with_existing_active());
            this.priority_delete_bucket_copy(config.priority_delete_bucket_copy());
            this.priority_join_buckets(config.priority_join_buckets());
            this.priority_split_distribution_bits(config.priority_split_distribution_bits());
            this.priority_split_large_bucket(config.priority_split_large_bucket());
            this.priority_split_inconsistent_bucket(config.priority_split_inconsistent_bucket());
            this.priority_garbage_collection(config.priority_garbage_collection());
            this.enable_join_for_sibling_less_buckets(config.enable_join_for_sibling_less_buckets());
            this.enable_inconsistent_join(config.enable_inconsistent_join());
            this.enable_host_info_reporting(config.enable_host_info_reporting());
            this.minimum_replica_counting_mode(config.minimum_replica_counting_mode());
            this.disable_bucket_activation(config.disable_bucket_activation());
            this.max_cluster_clock_skew_sec(config.max_cluster_clock_skew_sec());
            this.sequence_mutating_operations(config.sequence_mutating_operations());
            this.inhibit_merge_sending_on_busy_node_duration_sec(config.inhibit_merge_sending_on_busy_node_duration_sec());
            this.allow_stale_reads_during_cluster_state_transitions(config.allow_stale_reads_during_cluster_state_transitions());
            this.simulated_db_pruning_latency_msec(config.simulated_db_pruning_latency_msec());
            this.simulated_db_merging_latency_msec(config.simulated_db_merging_latency_msec());
            this.use_btree_database(config.use_btree_database());
            this.restart_with_fast_update_path_if_all_get_timestamps_are_consistent(config.restart_with_fast_update_path_if_all_get_timestamps_are_consistent());
            this.merge_operations_disabled(config.merge_operations_disabled());
            this.use_weak_internal_read_consistency_for_client_gets(config.use_weak_internal_read_consistency_for_client_gets());
            this.enable_metadata_only_fetch_phase_for_inconsistent_updates(config.enable_metadata_only_fetch_phase_for_inconsistent_updates());
            this.max_consecutively_inhibited_maintenance_ticks(config.max_consecutively_inhibited_maintenance_ticks());
        }

        private Builder override(Builder __superior) {
            if (__superior.maxpendingidealstateoperations != null) {
                this.maxpendingidealstateoperations(__superior.maxpendingidealstateoperations);
            }
            if (__superior.splitsize != null) {
                this.splitsize(__superior.splitsize);
            }
            if (__superior.splitcount != null) {
                this.splitcount(__superior.splitcount);
            }
            if (__superior.joinsize != null) {
                this.joinsize(__superior.joinsize);
            }
            if (__superior.joincount != null) {
                this.joincount(__superior.joincount);
            }
            if (__superior.minsplitcount != null) {
                this.minsplitcount(__superior.minsplitcount);
            }
            this.garbagecollection(this.garbagecollection.override(__superior.garbagecollection));
            if (__superior.inlinebucketsplitting != null) {
                this.inlinebucketsplitting(__superior.inlinebucketsplitting);
            }
            if (!__superior.blockedstatecheckers.isEmpty()) {
                this.blockedstatecheckers.addAll(__superior.blockedstatecheckers);
            }
            if (__superior.enable_revert != null) {
                this.enable_revert(__superior.enable_revert);
            }
            if (__superior.maximum_nodes_per_merge != null) {
                this.maximum_nodes_per_merge(__superior.maximum_nodes_per_merge);
            }
            if (__superior.start_distributor_thread != null) {
                this.start_distributor_thread(__superior.start_distributor_thread);
            }
            if (__superior.ticks_before_wait != null) {
                this.ticks_before_wait(__superior.ticks_before_wait);
            }
            if (__superior.ticks_wait_time_ms != null) {
                this.ticks_wait_time_ms(__superior.ticks_wait_time_ms);
            }
            if (__superior.max_process_time_ms != null) {
                this.max_process_time_ms(__superior.max_process_time_ms);
            }
            if (__superior.priority_merge_move_to_ideal_node != null) {
                this.priority_merge_move_to_ideal_node(__superior.priority_merge_move_to_ideal_node);
            }
            if (__superior.priority_merge_out_of_sync_copies != null) {
                this.priority_merge_out_of_sync_copies(__superior.priority_merge_out_of_sync_copies);
            }
            if (__superior.priority_merge_too_few_copies != null) {
                this.priority_merge_too_few_copies(__superior.priority_merge_too_few_copies);
            }
            if (__superior.priority_activate_no_existing_active != null) {
                this.priority_activate_no_existing_active(__superior.priority_activate_no_existing_active);
            }
            if (__superior.priority_activate_with_existing_active != null) {
                this.priority_activate_with_existing_active(__superior.priority_activate_with_existing_active);
            }
            if (__superior.priority_delete_bucket_copy != null) {
                this.priority_delete_bucket_copy(__superior.priority_delete_bucket_copy);
            }
            if (__superior.priority_join_buckets != null) {
                this.priority_join_buckets(__superior.priority_join_buckets);
            }
            if (__superior.priority_split_distribution_bits != null) {
                this.priority_split_distribution_bits(__superior.priority_split_distribution_bits);
            }
            if (__superior.priority_split_large_bucket != null) {
                this.priority_split_large_bucket(__superior.priority_split_large_bucket);
            }
            if (__superior.priority_split_inconsistent_bucket != null) {
                this.priority_split_inconsistent_bucket(__superior.priority_split_inconsistent_bucket);
            }
            if (__superior.priority_garbage_collection != null) {
                this.priority_garbage_collection(__superior.priority_garbage_collection);
            }
            if (__superior.enable_join_for_sibling_less_buckets != null) {
                this.enable_join_for_sibling_less_buckets(__superior.enable_join_for_sibling_less_buckets);
            }
            if (__superior.enable_inconsistent_join != null) {
                this.enable_inconsistent_join(__superior.enable_inconsistent_join);
            }
            if (__superior.enable_host_info_reporting != null) {
                this.enable_host_info_reporting(__superior.enable_host_info_reporting);
            }
            if (__superior.minimum_replica_counting_mode != null) {
                this.minimum_replica_counting_mode(__superior.minimum_replica_counting_mode);
            }
            if (__superior.disable_bucket_activation != null) {
                this.disable_bucket_activation(__superior.disable_bucket_activation);
            }
            if (__superior.max_cluster_clock_skew_sec != null) {
                this.max_cluster_clock_skew_sec(__superior.max_cluster_clock_skew_sec);
            }
            if (__superior.sequence_mutating_operations != null) {
                this.sequence_mutating_operations(__superior.sequence_mutating_operations);
            }
            if (__superior.inhibit_merge_sending_on_busy_node_duration_sec != null) {
                this.inhibit_merge_sending_on_busy_node_duration_sec(__superior.inhibit_merge_sending_on_busy_node_duration_sec);
            }
            if (__superior.allow_stale_reads_during_cluster_state_transitions != null) {
                this.allow_stale_reads_during_cluster_state_transitions(__superior.allow_stale_reads_during_cluster_state_transitions);
            }
            if (__superior.simulated_db_pruning_latency_msec != null) {
                this.simulated_db_pruning_latency_msec(__superior.simulated_db_pruning_latency_msec);
            }
            if (__superior.simulated_db_merging_latency_msec != null) {
                this.simulated_db_merging_latency_msec(__superior.simulated_db_merging_latency_msec);
            }
            if (__superior.use_btree_database != null) {
                this.use_btree_database(__superior.use_btree_database);
            }
            if (__superior.restart_with_fast_update_path_if_all_get_timestamps_are_consistent != null) {
                this.restart_with_fast_update_path_if_all_get_timestamps_are_consistent(__superior.restart_with_fast_update_path_if_all_get_timestamps_are_consistent);
            }
            if (__superior.merge_operations_disabled != null) {
                this.merge_operations_disabled(__superior.merge_operations_disabled);
            }
            if (__superior.use_weak_internal_read_consistency_for_client_gets != null) {
                this.use_weak_internal_read_consistency_for_client_gets(__superior.use_weak_internal_read_consistency_for_client_gets);
            }
            if (__superior.enable_metadata_only_fetch_phase_for_inconsistent_updates != null) {
                this.enable_metadata_only_fetch_phase_for_inconsistent_updates(__superior.enable_metadata_only_fetch_phase_for_inconsistent_updates);
            }
            if (__superior.max_consecutively_inhibited_maintenance_ticks != null) {
                this.max_consecutively_inhibited_maintenance_ticks(__superior.max_consecutively_inhibited_maintenance_ticks);
            }
            return this;
        }

        public Builder maxpendingidealstateoperations(int __value) {
            this.maxpendingidealstateoperations = __value;
            return this;
        }

        private Builder maxpendingidealstateoperations(String __value) {
            return this.maxpendingidealstateoperations(Integer.valueOf(__value));
        }

        public Builder splitsize(int __value) {
            this.splitsize = __value;
            return this;
        }

        private Builder splitsize(String __value) {
            return this.splitsize(Integer.valueOf(__value));
        }

        public Builder splitcount(int __value) {
            this.splitcount = __value;
            return this;
        }

        private Builder splitcount(String __value) {
            return this.splitcount(Integer.valueOf(__value));
        }

        public Builder joinsize(int __value) {
            this.joinsize = __value;
            return this;
        }

        private Builder joinsize(String __value) {
            return this.joinsize(Integer.valueOf(__value));
        }

        public Builder joincount(int __value) {
            this.joincount = __value;
            return this;
        }

        private Builder joincount(String __value) {
            return this.joincount(Integer.valueOf(__value));
        }

        public Builder minsplitcount(int __value) {
            this.minsplitcount = __value;
            return this;
        }

        private Builder minsplitcount(String __value) {
            return this.minsplitcount(Integer.valueOf(__value));
        }

        public Builder garbagecollection(Garbagecollection.Builder __builder) {
            this.garbagecollection = __builder;
            return this;
        }

        public Builder inlinebucketsplitting(boolean __value) {
            this.inlinebucketsplitting = __value;
            return this;
        }

        private Builder inlinebucketsplitting(String __value) {
            return this.inlinebucketsplitting(Boolean.valueOf(__value));
        }

        public Builder blockedstatecheckers(String __value) {
            this.blockedstatecheckers.add(__value);
            return this;
        }

        public Builder blockedstatecheckers(Collection<String> __values) {
            this.blockedstatecheckers.addAll(__values);
            return this;
        }

        public Builder enable_revert(boolean __value) {
            this.enable_revert = __value;
            return this;
        }

        private Builder enable_revert(String __value) {
            return this.enable_revert(Boolean.valueOf(__value));
        }

        public Builder maximum_nodes_per_merge(int __value) {
            this.maximum_nodes_per_merge = __value;
            return this;
        }

        private Builder maximum_nodes_per_merge(String __value) {
            return this.maximum_nodes_per_merge(Integer.valueOf(__value));
        }

        public Builder start_distributor_thread(boolean __value) {
            this.start_distributor_thread = __value;
            return this;
        }

        private Builder start_distributor_thread(String __value) {
            return this.start_distributor_thread(Boolean.valueOf(__value));
        }

        public Builder ticks_before_wait(int __value) {
            this.ticks_before_wait = __value;
            return this;
        }

        private Builder ticks_before_wait(String __value) {
            return this.ticks_before_wait(Integer.valueOf(__value));
        }

        public Builder ticks_wait_time_ms(int __value) {
            this.ticks_wait_time_ms = __value;
            return this;
        }

        private Builder ticks_wait_time_ms(String __value) {
            return this.ticks_wait_time_ms(Integer.valueOf(__value));
        }

        public Builder max_process_time_ms(int __value) {
            this.max_process_time_ms = __value;
            return this;
        }

        private Builder max_process_time_ms(String __value) {
            return this.max_process_time_ms(Integer.valueOf(__value));
        }

        public Builder priority_merge_move_to_ideal_node(int __value) {
            this.priority_merge_move_to_ideal_node = __value;
            return this;
        }

        private Builder priority_merge_move_to_ideal_node(String __value) {
            return this.priority_merge_move_to_ideal_node(Integer.valueOf(__value));
        }

        public Builder priority_merge_out_of_sync_copies(int __value) {
            this.priority_merge_out_of_sync_copies = __value;
            return this;
        }

        private Builder priority_merge_out_of_sync_copies(String __value) {
            return this.priority_merge_out_of_sync_copies(Integer.valueOf(__value));
        }

        public Builder priority_merge_too_few_copies(int __value) {
            this.priority_merge_too_few_copies = __value;
            return this;
        }

        private Builder priority_merge_too_few_copies(String __value) {
            return this.priority_merge_too_few_copies(Integer.valueOf(__value));
        }

        public Builder priority_activate_no_existing_active(int __value) {
            this.priority_activate_no_existing_active = __value;
            return this;
        }

        private Builder priority_activate_no_existing_active(String __value) {
            return this.priority_activate_no_existing_active(Integer.valueOf(__value));
        }

        public Builder priority_activate_with_existing_active(int __value) {
            this.priority_activate_with_existing_active = __value;
            return this;
        }

        private Builder priority_activate_with_existing_active(String __value) {
            return this.priority_activate_with_existing_active(Integer.valueOf(__value));
        }

        public Builder priority_delete_bucket_copy(int __value) {
            this.priority_delete_bucket_copy = __value;
            return this;
        }

        private Builder priority_delete_bucket_copy(String __value) {
            return this.priority_delete_bucket_copy(Integer.valueOf(__value));
        }

        public Builder priority_join_buckets(int __value) {
            this.priority_join_buckets = __value;
            return this;
        }

        private Builder priority_join_buckets(String __value) {
            return this.priority_join_buckets(Integer.valueOf(__value));
        }

        public Builder priority_split_distribution_bits(int __value) {
            this.priority_split_distribution_bits = __value;
            return this;
        }

        private Builder priority_split_distribution_bits(String __value) {
            return this.priority_split_distribution_bits(Integer.valueOf(__value));
        }

        public Builder priority_split_large_bucket(int __value) {
            this.priority_split_large_bucket = __value;
            return this;
        }

        private Builder priority_split_large_bucket(String __value) {
            return this.priority_split_large_bucket(Integer.valueOf(__value));
        }

        public Builder priority_split_inconsistent_bucket(int __value) {
            this.priority_split_inconsistent_bucket = __value;
            return this;
        }

        private Builder priority_split_inconsistent_bucket(String __value) {
            return this.priority_split_inconsistent_bucket(Integer.valueOf(__value));
        }

        public Builder priority_garbage_collection(int __value) {
            this.priority_garbage_collection = __value;
            return this;
        }

        private Builder priority_garbage_collection(String __value) {
            return this.priority_garbage_collection(Integer.valueOf(__value));
        }

        public Builder enable_join_for_sibling_less_buckets(boolean __value) {
            this.enable_join_for_sibling_less_buckets = __value;
            return this;
        }

        private Builder enable_join_for_sibling_less_buckets(String __value) {
            return this.enable_join_for_sibling_less_buckets(Boolean.valueOf(__value));
        }

        public Builder enable_inconsistent_join(boolean __value) {
            this.enable_inconsistent_join = __value;
            return this;
        }

        private Builder enable_inconsistent_join(String __value) {
            return this.enable_inconsistent_join(Boolean.valueOf(__value));
        }

        public Builder enable_host_info_reporting(boolean __value) {
            this.enable_host_info_reporting = __value;
            return this;
        }

        private Builder enable_host_info_reporting(String __value) {
            return this.enable_host_info_reporting(Boolean.valueOf(__value));
        }

        public Builder minimum_replica_counting_mode(Minimum_replica_counting_mode.Enum __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.minimum_replica_counting_mode = __value;
            return this;
        }

        private Builder minimum_replica_counting_mode(String __value) {
            return this.minimum_replica_counting_mode(Minimum_replica_counting_mode.Enum.valueOf(__value));
        }

        public Builder disable_bucket_activation(boolean __value) {
            this.disable_bucket_activation = __value;
            return this;
        }

        private Builder disable_bucket_activation(String __value) {
            return this.disable_bucket_activation(Boolean.valueOf(__value));
        }

        public Builder max_cluster_clock_skew_sec(int __value) {
            this.max_cluster_clock_skew_sec = __value;
            return this;
        }

        private Builder max_cluster_clock_skew_sec(String __value) {
            return this.max_cluster_clock_skew_sec(Integer.valueOf(__value));
        }

        public Builder sequence_mutating_operations(boolean __value) {
            this.sequence_mutating_operations = __value;
            return this;
        }

        private Builder sequence_mutating_operations(String __value) {
            return this.sequence_mutating_operations(Boolean.valueOf(__value));
        }

        public Builder inhibit_merge_sending_on_busy_node_duration_sec(int __value) {
            this.inhibit_merge_sending_on_busy_node_duration_sec = __value;
            return this;
        }

        private Builder inhibit_merge_sending_on_busy_node_duration_sec(String __value) {
            return this.inhibit_merge_sending_on_busy_node_duration_sec(Integer.valueOf(__value));
        }

        public Builder allow_stale_reads_during_cluster_state_transitions(boolean __value) {
            this.allow_stale_reads_during_cluster_state_transitions = __value;
            return this;
        }

        private Builder allow_stale_reads_during_cluster_state_transitions(String __value) {
            return this.allow_stale_reads_during_cluster_state_transitions(Boolean.valueOf(__value));
        }

        public Builder simulated_db_pruning_latency_msec(int __value) {
            this.simulated_db_pruning_latency_msec = __value;
            return this;
        }

        private Builder simulated_db_pruning_latency_msec(String __value) {
            return this.simulated_db_pruning_latency_msec(Integer.valueOf(__value));
        }

        public Builder simulated_db_merging_latency_msec(int __value) {
            this.simulated_db_merging_latency_msec = __value;
            return this;
        }

        private Builder simulated_db_merging_latency_msec(String __value) {
            return this.simulated_db_merging_latency_msec(Integer.valueOf(__value));
        }

        public Builder use_btree_database(boolean __value) {
            this.use_btree_database = __value;
            return this;
        }

        private Builder use_btree_database(String __value) {
            return this.use_btree_database(Boolean.valueOf(__value));
        }

        public Builder restart_with_fast_update_path_if_all_get_timestamps_are_consistent(boolean __value) {
            this.restart_with_fast_update_path_if_all_get_timestamps_are_consistent = __value;
            return this;
        }

        private Builder restart_with_fast_update_path_if_all_get_timestamps_are_consistent(String __value) {
            return this.restart_with_fast_update_path_if_all_get_timestamps_are_consistent(Boolean.valueOf(__value));
        }

        public Builder merge_operations_disabled(boolean __value) {
            this.merge_operations_disabled = __value;
            return this;
        }

        private Builder merge_operations_disabled(String __value) {
            return this.merge_operations_disabled(Boolean.valueOf(__value));
        }

        public Builder use_weak_internal_read_consistency_for_client_gets(boolean __value) {
            this.use_weak_internal_read_consistency_for_client_gets = __value;
            return this;
        }

        private Builder use_weak_internal_read_consistency_for_client_gets(String __value) {
            return this.use_weak_internal_read_consistency_for_client_gets(Boolean.valueOf(__value));
        }

        public Builder enable_metadata_only_fetch_phase_for_inconsistent_updates(boolean __value) {
            this.enable_metadata_only_fetch_phase_for_inconsistent_updates = __value;
            return this;
        }

        private Builder enable_metadata_only_fetch_phase_for_inconsistent_updates(String __value) {
            return this.enable_metadata_only_fetch_phase_for_inconsistent_updates(Boolean.valueOf(__value));
        }

        public Builder max_consecutively_inhibited_maintenance_ticks(int __value) {
            this.max_consecutively_inhibited_maintenance_ticks = __value;
            return this;
        }

        private Builder max_consecutively_inhibited_maintenance_ticks(String __value) {
            return this.max_consecutively_inhibited_maintenance_ticks(Integer.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return StorDistributormanagerConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return StorDistributormanagerConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return StorDistributormanagerConfig.CONFIG_DEF_NAMESPACE;
        }

        public StorDistributormanagerConfig build() {
            return new StorDistributormanagerConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

