/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.standalone;

import com.google.inject.AbstractModule;
import com.google.inject.ConfigurationException;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.ProvisionException;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.yahoo.collections.CollectionUtil;
import com.yahoo.collections.Pair;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.model.ApplicationConfigProducerRoot;
import com.yahoo.config.model.ConfigModelRepo;
import com.yahoo.config.model.api.ConfigDefinitionRepo;
import com.yahoo.config.model.application.provider.BaseDeployLogger;
import com.yahoo.config.model.application.provider.FilesApplicationPackage;
import com.yahoo.config.model.application.provider.StaticConfigDefinitionRepo;
import com.yahoo.config.model.builder.xml.ConfigModelId;
import com.yahoo.config.model.builder.xml.XmlHelper;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.config.provision.Environment;
import com.yahoo.config.provision.RegionName;
import com.yahoo.config.provision.SystemName;
import com.yahoo.config.provision.Zone;
import com.yahoo.container.Container;
import com.yahoo.container.di.config.SubscriberFactory;
import com.yahoo.container.jdisc.ConfiguredApplication;
import com.yahoo.container.standalone.CloudConfigInstallVariables;
import com.yahoo.container.standalone.LocalFileDb;
import com.yahoo.container.standalone.StandaloneSubscriberFactory;
import com.yahoo.filedistribution.fileacquirer.FileAcquirer;
import com.yahoo.io.IOUtils;
import com.yahoo.jdisc.application.Application;
import com.yahoo.text.XML;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.model.HostResource;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.builder.xml.dom.VespaDomBuilder;
import com.yahoo.vespa.model.container.ContainerModel;
import com.yahoo.vespa.model.container.configserver.option.CloudConfigOptions;
import com.yahoo.vespa.model.container.xml.ConfigServerContainerModelBuilder;
import com.yahoo.vespa.model.container.xml.ContainerModelBuilder;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.w3c.dom.Element;

public class StandaloneContainerApplication
implements Application {
    public static final String PACKAGE_NAME = "standalone_jdisc_container";
    public static final String APPLICATION_LOCATION_INSTALL_VARIABLE = "standalone_jdisc_container.app_location";
    public static final String DEPLOYMENT_PROFILE_INSTALL_VARIABLE = "standalone_jdisc_container.deployment_profile";
    public static final String DISABLE_NETWORKING_ANNOTATION = "JDisc.disableNetworking";
    public static final Named APPLICATION_PATH_NAME = Names.named((String)"standalone_jdisc_container.app_location");
    public static final Named CONFIG_MODEL_REPO_NAME = Names.named((String)"ConfigModelRepo");
    private static final String DEFAULT_TMP_BASE_DIR = Defaults.getDefaults().underVespaHome("var/tmp");
    private static final String TMP_DIR_NAME = "standalone_container";
    private static final StaticConfigDefinitionRepo configDefinitionRepo = new StaticConfigDefinitionRepo();
    private final Injector injector;
    private final Path applicationPath;
    private final LocalFileDb distributedFiles;
    private final ConfigModelRepo configModelRepo;
    private final ContainerModelBuilder.Networking networkingOption;
    private final VespaModel modelRoot;
    private final Application configuredApplication;
    private final com.yahoo.vespa.model.container.Container container;

    @Inject
    public StandaloneContainerApplication(Injector injector) {
        this.injector = injector;
        ConfiguredApplication.ensureVespaLoggingInitialized();
        this.applicationPath = this.injectedApplicationPath().orElseGet(this::installApplicationPath);
        this.distributedFiles = new LocalFileDb(this.applicationPath);
        this.configModelRepo = this.resolveConfigModelRepo();
        this.networkingOption = this.resolveNetworkingOption();
        try {
            Pair tpl = StandaloneContainerApplication.withTempDir(preprocessedApplicationDir -> StandaloneContainerApplication.createContainerModel(this.applicationPath, this.distributedFiles, preprocessedApplicationDir, this.networkingOption, this.configModelRepo));
            this.modelRoot = (VespaModel)tpl.getFirst();
            this.container = (com.yahoo.vespa.model.container.Container)tpl.getSecond();
        }
        catch (RuntimeException r) {
            throw r;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create ContainerModel", e);
        }
        this.configuredApplication = this.createConfiguredApplication(this.container);
    }

    private ConfigModelRepo resolveConfigModelRepo() {
        try {
            return (ConfigModelRepo)this.injector.getInstance(Key.get(ConfigModelRepo.class, (Annotation)CONFIG_MODEL_REPO_NAME));
        }
        catch (Exception e) {
            return new ConfigModelRepo();
        }
    }

    private ContainerModelBuilder.Networking resolveNetworkingOption() {
        try {
            Boolean networkingDisable = (Boolean)this.injector.getInstance(Key.get(Boolean.class, (Annotation)Names.named((String)DISABLE_NETWORKING_ANNOTATION)));
            if (networkingDisable != null) {
                return networkingDisable != false ? ContainerModelBuilder.Networking.disable : ContainerModelBuilder.Networking.enable;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ContainerModelBuilder.Networking.enable;
    }

    private Application createConfiguredApplication(com.yahoo.vespa.model.container.Container container) {
        Injector augmentedInjector = this.injector.createChildInjector(new Module[]{new AbstractModule(){

            public void configure() {
                this.bind(SubscriberFactory.class).toInstance((Object)new StandaloneSubscriberFactory(StandaloneContainerApplication.this.modelRoot));
            }
        }});
        System.setProperty("config.id", container.getConfigId());
        return (Application)augmentedInjector.getInstance(ConfiguredApplication.class);
    }

    private Optional<Path> injectedApplicationPath() {
        try {
            return Optional.ofNullable((Path)this.injector.getInstance(Key.get(Path.class, (Annotation)APPLICATION_PATH_NAME)));
        }
        catch (ConfigurationException | ProvisionException throwable) {
            return Optional.empty();
        }
    }

    private Path installApplicationPath() {
        Optional<String> variable = StandaloneContainerApplication.optionalInstallVariable(APPLICATION_LOCATION_INSTALL_VARIABLE);
        return variable.map(x$0 -> Paths.get(x$0, new String[0])).orElseThrow(() -> new IllegalStateException("Environment variable not set: standalone_jdisc_container.app_location"));
    }

    public void start() {
        try {
            Container.get().setCustomFileAcquirer((FileAcquirer)this.distributedFiles);
            Container.get().disableUrlDownloader();
            this.configuredApplication.start();
        }
        catch (Exception e) {
            Container.resetInstance();
            throw e;
        }
    }

    public void stop() {
        this.configuredApplication.stop();
    }

    public void destroy() {
        Container.resetInstance();
        this.configuredApplication.destroy();
    }

    public com.yahoo.vespa.model.container.Container container() {
        return this.container;
    }

    private static <T> T withTempDir(ThrowingFunction<File, T> f) throws Exception {
        File tmpDir = StandaloneContainerApplication.createTempDir();
        try {
            T t = f.apply(tmpDir);
            return t;
        }
        finally {
            IOUtils.recursiveDeleteDir((File)tmpDir);
        }
    }

    private static File createTempDir() {
        Path basePath = new File(DEFAULT_TMP_BASE_DIR).exists() ? Paths.get(DEFAULT_TMP_BASE_DIR, new String[0]) : Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
        try {
            Path tmpDir = Files.createTempDirectory(basePath, TMP_DIR_NAME, new FileAttribute[0]);
            return tmpDir.toFile();
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot create temp directory", e);
        }
    }

    private static void validateApplication(ApplicationPackage applicationPackage) {
        try {
            applicationPackage.validateXML();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static ContainerModelBuilder newContainerModelBuilder(ContainerModelBuilder.Networking networkingOption) {
        return StandaloneContainerApplication.isConfigServer() ? new ConfigServerContainerModelBuilder((CloudConfigOptions)new CloudConfigInstallVariables()) : new ContainerModelBuilder(true, networkingOption);
    }

    private static boolean isConfigServer() {
        Optional<String> profile = StandaloneContainerApplication.optionalInstallVariable(DEPLOYMENT_PROFILE_INSTALL_VARIABLE);
        if (profile.isPresent()) {
            String profileName = profile.get();
            if (profileName.equals("configserver")) {
                return true;
            }
            throw new RuntimeException("Invalid deployment profile '" + profileName + "'");
        }
        return false;
    }

    static Pair<VespaModel, com.yahoo.vespa.model.container.Container> createContainerModel(Path applicationPath, FileRegistry fileRegistry, File preprocessedApplicationDir, ContainerModelBuilder.Networking networkingOption, ConfigModelRepo configModelRepo) throws Exception {
        BaseDeployLogger logger = new BaseDeployLogger();
        FilesApplicationPackage rawApplicationPackage = new FilesApplicationPackage.Builder(applicationPath.toFile()).includeSourceFiles(true).preprocessedDir(preprocessedApplicationDir).build();
        ApplicationPackage applicationPackage = rawApplicationPackage.preprocess(StandaloneContainerApplication.getZone(), (DeployLogger)logger);
        StandaloneContainerApplication.validateApplication(applicationPackage);
        DeployState deployState = StandaloneContainerApplication.createDeployState(applicationPackage, fileRegistry, (DeployLogger)logger);
        VespaModel root = VespaModel.createIncomplete((DeployState)deployState);
        ApplicationConfigProducerRoot vespaRoot = new ApplicationConfigProducerRoot((AbstractConfigProducer)root, "vespa", deployState.getDocumentModel(), deployState.getVespaVersion(), deployState.getProperties().applicationId());
        Element spec = StandaloneContainerApplication.containerRootElement(applicationPackage);
        ContainerModel containerModel = (ContainerModel)StandaloneContainerApplication.newContainerModelBuilder(networkingOption).build(deployState, root, configModelRepo, (AbstractConfigProducer)vespaRoot, spec);
        containerModel.getCluster().prepare(deployState);
        StandaloneContainerApplication.initializeContainerModel(containerModel, configModelRepo);
        com.yahoo.vespa.model.container.Container container = (com.yahoo.vespa.model.container.Container)CollectionUtil.first((Collection)containerModel.getCluster().getContainers());
        StandaloneContainerApplication.initializeContainer(deployState, container, spec);
        root.freezeModelTopology();
        return new Pair((Object)root, (Object)container);
    }

    private static Zone getZone() {
        if (!StandaloneContainerApplication.isConfigServer()) {
            return Zone.defaultZone();
        }
        CloudConfigInstallVariables cloudConfigVariables = new CloudConfigInstallVariables();
        if (!cloudConfigVariables.hostedVespa().orElse(false).booleanValue()) {
            return Zone.defaultZone();
        }
        RegionName region = cloudConfigVariables.region().map(RegionName::from).orElseGet(RegionName::defaultName);
        Environment environment = cloudConfigVariables.environment().map(Environment::from).orElseGet(Environment::defaultEnvironment);
        SystemName system = cloudConfigVariables.system().map(SystemName::from).orElseGet(SystemName::defaultSystem);
        return new Zone(system, environment, region);
    }

    private static DeployState createDeployState(ApplicationPackage applicationPackage, FileRegistry fileRegistry, DeployLogger logger) {
        DeployState.Builder builder = new DeployState.Builder().applicationPackage(applicationPackage).fileRegistry(fileRegistry).deployLogger(logger).configDefinitionRepo((ConfigDefinitionRepo)configDefinitionRepo);
        return builder.build();
    }

    private static void initializeContainer(DeployState deployState, com.yahoo.vespa.model.container.Container container, Element spec) {
        HostResource host = container.getRoot().hostSystem().getHost("default_singlenode_container");
        container.setBasePort(VespaDomBuilder.getXmlWantedPort((Element)spec));
        container.setHostResource(host);
        container.initService(deployState);
    }

    private static Element getJDiscInServices(Element element) {
        ArrayList jDiscElements = new ArrayList();
        for (ConfigModelId cid : ContainerModelBuilder.configModelIds) {
            List children = XML.getChildren((Element)element, (String)cid.getName());
            jDiscElements.addAll(children);
        }
        if (jDiscElements.size() == 1) {
            return (Element)jDiscElements.get(0);
        }
        if (jDiscElements.isEmpty()) {
            throw new RuntimeException("No jdisc element found under services.");
        }
        List<String> nameAndId = jDiscElements.stream().map(e -> e.getNodeName() + " id='" + e.getAttribute("id") + "'").toList();
        throw new RuntimeException("Found multiple JDisc elements: " + String.join((CharSequence)", ", nameAndId));
    }

    private static Element containerRootElement(ApplicationPackage applicationPackage) {
        Element element = XmlHelper.getDocument((Reader)applicationPackage.getServices()).getDocumentElement();
        String nodeName = element.getNodeName();
        if (ContainerModelBuilder.configModelIds.stream().anyMatch(id -> id.getName().equals(nodeName))) {
            return element;
        }
        return StandaloneContainerApplication.getJDiscInServices(element);
    }

    private static void initializeContainerModel(ContainerModel containerModel, ConfigModelRepo configModelRepo) {
        containerModel.initialize(configModelRepo);
    }

    private static Optional<String> optionalInstallVariable(String name) {
        Optional<String> fromEnv = Optional.ofNullable(System.getenv(name.replace(".", "__")));
        if (fromEnv.isPresent()) {
            return fromEnv;
        }
        return Optional.ofNullable(System.getProperty(name));
    }

    private static interface ThrowingFunction<T, U> {
        public U apply(T var1) throws Exception;
    }
}

