/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security;

import com.yahoo.security.KeyId;
import com.yahoo.security.SealedSharedKey;
import com.yahoo.security.SecretSharedKey;
import com.yahoo.security.hpke.Aead;
import com.yahoo.security.hpke.Ciphersuite;
import com.yahoo.security.hpke.Hpke;
import com.yahoo.security.hpke.Kdf;
import com.yahoo.security.hpke.Kem;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.XECPrivateKey;
import java.security.interfaces.XECPublicKey;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class SharedKeyGenerator {
    private static final int AES_GCM_KEY_BITS = 128;
    private static final int AES_GCM_AUTH_TAG_BITS = 128;
    private static final String AES_GCM_ALGO_SPEC = "AES/GCM/NoPadding";
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final SecureRandom SHARED_CSPRNG = new SecureRandom();
    private static final Ciphersuite HPKE_CIPHERSUITE = Ciphersuite.of(Kem.dHKemX25519HkdfSha256(), Kdf.hkdfSha256(), Aead.aesGcm128());
    private static final Hpke HPKE = Hpke.of(HPKE_CIPHERSUITE);
    private static final byte[] FIXED_96BIT_IV_FOR_SINGLE_USE_KEY = new byte[]{104, 101, 114, 101, 66, 100, 114, 97, 103, 111, 110, 115};

    private static SecretKey generateRandomSecretAesKey() {
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance("AES");
            keyGen.init(128, SHARED_CSPRNG);
            return keyGen.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static SecretSharedKey generateForReceiverPublicKey(PublicKey receiverPublicKey, KeyId keyId) {
        SecretKey secretKey = SharedKeyGenerator.generateRandomSecretAesKey();
        Hpke.Sealed sealed = HPKE.sealBase((XECPublicKey)receiverPublicKey, EMPTY_BYTES, keyId.asBytes(), secretKey.getEncoded());
        SealedSharedKey sealedSharedKey = new SealedSharedKey(keyId, sealed.enc(), sealed.ciphertext());
        return new SecretSharedKey(secretKey, sealedSharedKey);
    }

    public static SecretSharedKey fromSealedKey(SealedSharedKey sealedKey, PrivateKey receiverPrivateKey) {
        byte[] secretKeyBytes = HPKE.openBase(sealedKey.enc(), (XECPrivateKey)receiverPrivateKey, EMPTY_BYTES, sealedKey.keyId().asBytes(), sealedKey.ciphertext());
        return new SecretSharedKey(new SecretKeySpec(secretKeyBytes, "AES"), sealedKey);
    }

    private static Cipher makeAesGcmCipher(SecretSharedKey secretSharedKey, int cipherMode) {
        try {
            Cipher cipher = Cipher.getInstance(AES_GCM_ALGO_SPEC);
            GCMParameterSpec gcmSpec = new GCMParameterSpec(128, FIXED_96BIT_IV_FOR_SINGLE_USE_KEY);
            cipher.init(cipherMode, (Key)secretSharedKey.secretKey(), gcmSpec);
            return cipher;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }

    public static Cipher makeAesGcmEncryptionCipher(SecretSharedKey secretSharedKey) {
        return SharedKeyGenerator.makeAesGcmCipher(secretSharedKey, 1);
    }

    public static Cipher makeAesGcmDecryptionCipher(SecretSharedKey secretSharedKey) {
        return SharedKeyGenerator.makeAesGcmCipher(secretSharedKey, 2);
    }
}

