/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security;

import java.nio.ByteBuffer;
import java.util.Base64;

public record SealedSharedKey(int keyId, byte[] eciesPayload, byte[] iv) {
    public static final int CURRENT_TOKEN_VERSION = 1;
    private static final int ECIES_AES_IV_LENGTH = 16;

    public String toTokenString() {
        if (this.keyId >= 0x1000000) {
            throw new IllegalArgumentException("Key id is too large to be encoded");
        }
        if (this.iv.length != 16) {
            throw new IllegalStateException("Expected a %d byte IV, got %d bytes".formatted(16, this.iv.length));
        }
        ByteBuffer encoded = ByteBuffer.allocate(20 + this.eciesPayload.length);
        encoded.putInt(0x1000000 | this.keyId);
        encoded.put(this.iv);
        encoded.put(this.eciesPayload);
        encoded.flip();
        byte[] encBytes = new byte[encoded.remaining()];
        encoded.get(encBytes);
        return Base64.getUrlEncoder().withoutPadding().encodeToString(encBytes);
    }

    public static SealedSharedKey fromTokenString(String tokenString) {
        byte[] rawTokenBytes = Base64.getUrlDecoder().decode(tokenString);
        if (rawTokenBytes.length < 4) {
            throw new IllegalArgumentException("Decoded token too small to contain a header");
        }
        ByteBuffer decoded = ByteBuffer.wrap(rawTokenBytes);
        int versionAndKeyId = decoded.getInt();
        int version = versionAndKeyId >>> 24;
        if (version != 1) {
            throw new IllegalArgumentException("Token had unexpected version. Expected %d, was %d".formatted(1, version));
        }
        byte[] iv = new byte[16];
        decoded.get(iv);
        byte[] eciesPayload = new byte[decoded.remaining()];
        decoded.get(eciesPayload);
        int keyId = versionAndKeyId & 0xFFFFFF;
        return new SealedSharedKey(keyId, eciesPayload, iv);
    }
}

