/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security;

import com.yahoo.security.BouncyCastleProviderHolder;
import com.yahoo.security.SealedSharedKey;
import com.yahoo.security.SecretSharedKey;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jcajce.provider.util.BadBlockException;

public class SharedKeyGenerator {
    private static final int AES_GCM_AUTH_TAG_BITS = 128;
    private static final String AES_GCM_ALGO_SPEC = "AES/GCM/NoPadding";
    private static final String ECIES_CIPHER_NAME = "ECIES";
    private static final SecureRandom SHARED_CSPRNG = new SecureRandom();

    public static SecretSharedKey generateForReceiverPublicKey(PublicKey receiverPublicKey, int keyId) {
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance("AES");
            keyGen.init(256, SHARED_CSPRNG);
            SecretKey secretKey = keyGen.generateKey();
            Cipher cipher = Cipher.getInstance(ECIES_CIPHER_NAME, (Provider)BouncyCastleProviderHolder.getInstance());
            cipher.init(1, receiverPublicKey);
            byte[] eciesPayload = cipher.doFinal(secretKey.getEncoded());
            SealedSharedKey sealedSharedKey = new SealedSharedKey(keyId, eciesPayload);
            return new SecretSharedKey(secretKey, sealedSharedKey);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }

    public static SecretSharedKey fromSealedKey(SealedSharedKey sealedKey, PrivateKey receiverPrivateKey) {
        try {
            Cipher cipher = Cipher.getInstance(ECIES_CIPHER_NAME, (Provider)BouncyCastleProviderHolder.getInstance());
            cipher.init(2, receiverPrivateKey);
            byte[] secretKey = cipher.doFinal(sealedKey.eciesPayload());
            return new SecretSharedKey(new SecretKeySpec(secretKey, "AES"), sealedKey);
        }
        catch (BadBlockException e) {
            throw new IllegalArgumentException("Token integrity check failed; token is either corrupt or was generated for a different public key");
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] fixed96BitIvForSingleUseKey() {
        return new byte[]{104, 101, 114, 101, 66, 100, 114, 97, 103, 111, 110, 115};
    }

    private static Cipher makeAes256GcmCipher(SecretSharedKey secretSharedKey, int cipherMode) {
        try {
            Cipher cipher = Cipher.getInstance(AES_GCM_ALGO_SPEC);
            GCMParameterSpec gcmSpec = new GCMParameterSpec(128, SharedKeyGenerator.fixed96BitIvForSingleUseKey());
            cipher.init(cipherMode, (Key)secretSharedKey.secretKey(), gcmSpec);
            return cipher;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }

    public static Cipher makeAes256GcmEncryptionCipher(SecretSharedKey secretSharedKey) {
        return SharedKeyGenerator.makeAes256GcmCipher(secretSharedKey, 1);
    }

    public static Cipher makeAes256GcmDecryptionCipher(SecretSharedKey secretSharedKey) {
        return SharedKeyGenerator.makeAes256GcmCipher(secretSharedKey, 2);
    }
}

