/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security.hpke;

import com.yahoo.security.KeyUtils;
import com.yahoo.security.hpke.DHKemX25519HkdfSha256;
import java.security.KeyPair;
import java.security.interfaces.XECPrivateKey;
import java.security.interfaces.XECPublicKey;

public interface Kem {
    public EncapResult encap(XECPublicKey var1);

    public EncapResult authEncap(XECPublicKey var1, XECPrivateKey var2);

    public byte[] decap(byte[] var1, XECPrivateKey var2);

    public byte[] authDecap(byte[] var1, XECPrivateKey var2, XECPublicKey var3);

    public short nSecret();

    public short nEnc();

    public short nPk();

    public short nSk();

    public short kemId();

    public static Kem dHKemX25519HkdfSha256() {
        return new DHKemX25519HkdfSha256(KeyUtils::generateX25519KeyPair);
    }

    public static Kem dHKemX25519HkdfSha256(UnsafeDeterminsticKeyPairOnlyUsedByTesting testingKP) {
        return new DHKemX25519HkdfSha256(() -> testingKP.keyPair);
    }

    public record UnsafeDeterminsticKeyPairOnlyUsedByTesting(KeyPair keyPair) {
    }

    public record EncapResult(byte[] sharedSecret, byte[] enc) {
    }
}

