/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security.tls;

import com.yahoo.security.tls.PeerPolicy;
import java.util.Set;

public record AuthorizedPeers(Set<PeerPolicy> peerPolicies) {
    private static final AuthorizedPeers EMPTY = new AuthorizedPeers(Set.of());

    public AuthorizedPeers {
        peerPolicies = AuthorizedPeers.verifyPeerPolicies(peerPolicies);
    }

    public static AuthorizedPeers empty() {
        return EMPTY;
    }

    private static Set<PeerPolicy> verifyPeerPolicies(Set<PeerPolicy> peerPolicies) {
        long distinctNames = peerPolicies.stream().map(PeerPolicy::policyName).distinct().count();
        if (distinctNames != (long)peerPolicies.size()) {
            throw new IllegalArgumentException("'authorized-peers' contains entries with duplicate names");
        }
        return Set.copyOf(peerPolicies);
    }

    public boolean isEmpty() {
        return this.peerPolicies.isEmpty();
    }
}

