/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyStore;

public class KeyStoreUtils {
    private KeyStoreUtils() {
    }

    public static void writeKeyStoreToFile(KeyStore keyStore, Path file, char[] password) {
        try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(file, new OpenOption[0]));){
            keyStore.store(out, password);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeKeyStoreToFile(KeyStore keyStore, Path file) {
        KeyStoreUtils.writeKeyStoreToFile(keyStore, file, new char[0]);
    }
}

