/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security;

import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public final class HKDF {
    private static final int HASH_LEN = 32;
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final byte[] ALL_ZEROS_SALT = new byte[32];
    public static final int MAX_OUTPUT_SIZE = 8160;
    private final byte[] pseudoRandomKey;

    private HKDF(byte[] pseudoRandomKey) {
        this.pseudoRandomKey = pseudoRandomKey;
    }

    private static Mac createHmacSha256() {
        try {
            return Mac.getInstance("HmacSHA256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] pseudoRandomKey() {
        return this.pseudoRandomKey;
    }

    public static HKDF ofPseudoRandomKey(byte[] prk) {
        return new HKDF(prk);
    }

    private static SecretKeySpec hmacKeyFrom(byte[] rawKey) {
        return new SecretKeySpec(rawKey, "HmacSHA256");
    }

    private static Mac createKeyedHmacSha256(byte[] rawKey) {
        Mac hmac = HKDF.createHmacSha256();
        try {
            hmac.init(HKDF.hmacKeyFrom(rawKey));
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
        return hmac;
    }

    private static void validateExtractionParams(byte[] salt, byte[] ikm) {
        Objects.requireNonNull(salt);
        Objects.requireNonNull(ikm);
        if (ikm.length == 0) {
            throw new IllegalArgumentException("HKDF extraction IKM array can not be empty");
        }
        if (salt.length == 0) {
            throw new IllegalArgumentException("HKDF extraction salt array can not be empty");
        }
    }

    public static HKDF extractedFrom(byte[] salt, byte[] ikm) {
        HKDF.validateExtractionParams(salt, ikm);
        Mac mac = HKDF.createKeyedHmacSha256(salt);
        mac.update(ikm);
        return new HKDF(mac.doFinal());
    }

    public static HKDF unsaltedExtractedFrom(byte[] ikm) {
        return HKDF.extractedFrom(ALL_ZEROS_SALT, ikm);
    }

    public byte[] expand(int wantedBytes, byte[] context) {
        Objects.requireNonNull(context);
        this.verifyWantedBytesWithinBounds(wantedBytes);
        return this.expandImpl(wantedBytes, context);
    }

    public byte[] expand(int wantedBytes) {
        return this.expand(wantedBytes, EMPTY_BYTES);
    }

    private void verifyWantedBytesWithinBounds(int wantedBytes) {
        if (wantedBytes <= 0) {
            throw new IllegalArgumentException("Requested negative or zero number of HKDF output bytes");
        }
        if (wantedBytes > 8160) {
            throw new IllegalArgumentException("Too many requested HKDF output bytes (max %d, got %d)".formatted(8160, wantedBytes));
        }
    }

    private byte[] expandImpl(int wantedBytes, byte[] context) {
        Mac prkHmac = HKDF.createKeyedHmacSha256(this.pseudoRandomKey);
        int blocks = wantedBytes / 32 + (wantedBytes % 32 != 0 ? 1 : 0);
        ByteBuffer buffer = ByteBuffer.allocate(blocks * 32);
        byte[] lastBlock = EMPTY_BYTES;
        for (int i = 0; i < blocks; ++i) {
            prkHmac.update(lastBlock);
            prkHmac.update(context);
            prkHmac.update((byte)(i + 1));
            lastBlock = prkHmac.doFinal();
            buffer.put(lastBlock);
        }
        buffer.flip();
        byte[] outputKeyingMaterial = new byte[wantedBytes];
        buffer.get(outputKeyingMaterial);
        return outputKeyingMaterial;
    }
}

