/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security.token;

import com.yahoo.security.Base62;
import com.yahoo.security.token.Token;
import com.yahoo.security.token.TokenDomain;
import java.security.SecureRandom;

public class TokenGenerator {
    private static final SecureRandom CSPRNG = new SecureRandom();

    public static Token generateToken(TokenDomain domain, String prefix, int nRandomBytes) {
        if (nRandomBytes <= 0) {
            throw new IllegalArgumentException("Token bytes must be a positive integer");
        }
        byte[] tokenRand = new byte[nRandomBytes];
        CSPRNG.nextBytes(tokenRand);
        return new Token(domain, "%s%s".formatted(prefix, Base62.codec().encode(tokenRand)));
    }
}

