/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security;

import com.yahoo.security.KeyStoreType;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class KeyStoreBuilder {
    private final List<KeyEntry> keyEntries = new ArrayList<KeyEntry>();
    private final List<CertificateEntry> certificateEntries = new ArrayList<CertificateEntry>();
    private final KeyStoreType keyStoreType;
    private Path inputFile;
    private char[] inputFilePassword;

    private KeyStoreBuilder(KeyStoreType keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public static KeyStoreBuilder withType(KeyStoreType type) {
        return new KeyStoreBuilder(type);
    }

    public KeyStoreBuilder fromFile(Path file, char[] password) {
        this.inputFile = file;
        this.inputFilePassword = password;
        return this;
    }

    public KeyStoreBuilder fromFile(Path file) {
        return this.fromFile(file, null);
    }

    public KeyStoreBuilder withKeyEntry(String alias, PrivateKey privateKey, char[] password, List<X509Certificate> certificateChain) {
        this.keyEntries.add(new KeyEntry(alias, privateKey, certificateChain, password));
        return this;
    }

    public KeyStoreBuilder withKeyEntry(String alias, PrivateKey privateKey, char[] password, X509Certificate certificate) {
        return this.withKeyEntry(alias, privateKey, password, Collections.singletonList(certificate));
    }

    public KeyStoreBuilder withKeyEntry(String alias, PrivateKey privateKey, X509Certificate certificate) {
        return this.withKeyEntry(alias, privateKey, null, certificate);
    }

    public KeyStoreBuilder withKeyEntry(String alias, PrivateKey privateKey, List<X509Certificate> certificateChain) {
        return this.withKeyEntry(alias, privateKey, null, certificateChain);
    }

    public KeyStoreBuilder withCertificateEntry(String alias, X509Certificate certificate) {
        this.certificateEntries.add(new CertificateEntry(alias, certificate));
        return this;
    }

    public KeyStoreBuilder withCertificateEntries(String aliasPrefix, List<X509Certificate> certificates) {
        for (int i = 0; i < certificates.size(); ++i) {
            this.withCertificateEntry(aliasPrefix + "-" + i, certificates.get(i));
        }
        return this;
    }

    public KeyStore build() {
        try {
            KeyStore keystore = this.keyStoreType.createKeystore();
            if (this.inputFile != null) {
                try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(this.inputFile, new OpenOption[0]));){
                    keystore.load(in, this.inputFilePassword);
                }
            } else {
                keystore.load(null);
            }
            for (KeyEntry keyEntry : this.keyEntries) {
                char[] password = keyEntry.password != null ? keyEntry.password : new char[]{};
                Certificate[] certificateChain = keyEntry.certificateChain.toArray(new Certificate[keyEntry.certificateChain.size()]);
                keystore.setKeyEntry(keyEntry.alias, keyEntry.privateKey, password, certificateChain);
            }
            for (CertificateEntry certificateEntry : this.certificateEntries) {
                keystore.setCertificateEntry(certificateEntry.alias, certificateEntry.certificate);
            }
            KeyStore keyStore = keystore;
            return keyStore;
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            this.inputFilePassword = null;
        }
    }

    private static class KeyEntry {
        final String alias;
        final PrivateKey privateKey;
        final List<X509Certificate> certificateChain;
        final char[] password;

        KeyEntry(String alias, PrivateKey privateKey, List<X509Certificate> certificateChain, char[] password) {
            this.alias = alias;
            this.privateKey = privateKey;
            this.certificateChain = certificateChain;
            this.password = password;
        }
    }

    private static class CertificateEntry {
        final String alias;
        final X509Certificate certificate;

        CertificateEntry(String alias, X509Certificate certificate) {
            this.alias = alias;
            this.certificate = certificate;
        }
    }
}

