/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security;

import com.yahoo.security.BasicConstraintsExtension;
import com.yahoo.security.BouncyCastleProviderHolder;
import com.yahoo.security.Pkcs10Csr;
import com.yahoo.security.SignatureAlgorithm;
import com.yahoo.security.SubjectAlternativeName;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.security.KeyPair;
import java.security.Provider;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.ExtensionsGenerator;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;

public class Pkcs10CsrBuilder {
    private final X500Principal subject;
    private final KeyPair keyPair;
    private final List<SubjectAlternativeName> subjectAlternativeNames = new ArrayList<SubjectAlternativeName>();
    private final SignatureAlgorithm signatureAlgorithm;
    private BasicConstraintsExtension basicConstraintsExtension;

    private Pkcs10CsrBuilder(X500Principal subject, KeyPair keyPair, SignatureAlgorithm signatureAlgorithm) {
        this.subject = subject;
        this.keyPair = keyPair;
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public static Pkcs10CsrBuilder fromKeypair(X500Principal subject, KeyPair keyPair, SignatureAlgorithm signatureAlgorithm) {
        return new Pkcs10CsrBuilder(subject, keyPair, signatureAlgorithm);
    }

    public Pkcs10CsrBuilder addSubjectAlternativeName(String dns) {
        this.subjectAlternativeNames.add(new SubjectAlternativeName(SubjectAlternativeName.Type.DNS, dns));
        return this;
    }

    public Pkcs10CsrBuilder addSubjectAlternativeName(SubjectAlternativeName san) {
        this.subjectAlternativeNames.add(san);
        return this;
    }

    public Pkcs10CsrBuilder addSubjectAlternativeName(SubjectAlternativeName.Type type, String value) {
        this.subjectAlternativeNames.add(new SubjectAlternativeName(type, value));
        return this;
    }

    public Pkcs10CsrBuilder setBasicConstraints(boolean isCritical, boolean isCertAuthorityCertificate) {
        this.basicConstraintsExtension = new BasicConstraintsExtension(isCritical, isCertAuthorityCertificate);
        return this;
    }

    public Pkcs10CsrBuilder setIsCertAuthority(boolean isCertAuthority) {
        return this.setBasicConstraints(true, isCertAuthority);
    }

    public Pkcs10Csr build() {
        try {
            JcaPKCS10CertificationRequestBuilder requestBuilder = new JcaPKCS10CertificationRequestBuilder(new X500Name(this.subject.getName()), this.keyPair.getPublic());
            ExtensionsGenerator extGen = new ExtensionsGenerator();
            if (this.basicConstraintsExtension != null) {
                extGen.addExtension(Extension.basicConstraints, this.basicConstraintsExtension.isCritical, (ASN1Encodable)new BasicConstraints(this.basicConstraintsExtension.isCertAuthorityCertificate));
            }
            if (!this.subjectAlternativeNames.isEmpty()) {
                GeneralNames generalNames = new GeneralNames((GeneralName[])this.subjectAlternativeNames.stream().map(SubjectAlternativeName::toGeneralName).toArray(GeneralName[]::new));
                extGen.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)generalNames);
            }
            requestBuilder.addAttribute(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest, (ASN1Encodable)extGen.generate());
            ContentSigner contentSigner = new JcaContentSignerBuilder(this.signatureAlgorithm.getAlgorithmName()).setProvider((Provider)BouncyCastleProviderHolder.getInstance()).build(this.keyPair.getPrivate());
            return new Pkcs10Csr(requestBuilder.build(contentSigner));
        }
        catch (OperatorCreationException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

