/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security.tls.policy;

import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Pattern;

class GlobPattern {
    private final String pattern;
    private final char[] boundaries;
    private final Pattern regexPattern;

    GlobPattern(String pattern, char[] boundaries, boolean enableSingleCharWildcard) {
        this.pattern = pattern;
        this.boundaries = boundaries;
        this.regexPattern = GlobPattern.toRegexPattern(pattern, boundaries, enableSingleCharWildcard);
    }

    boolean matches(String value) {
        return this.regexPattern.matcher(value).matches();
    }

    String asString() {
        return this.pattern;
    }

    Pattern regexPattern() {
        return this.regexPattern;
    }

    char[] boundaries() {
        return this.boundaries;
    }

    private static Pattern toRegexPattern(String pattern, char[] boundaries, boolean enableSingleCharWildcard) {
        char[] chars;
        StringBuilder builder = new StringBuilder("^");
        StringBuilder precedingCharactersToQuote = new StringBuilder();
        for (char c : chars = pattern.toCharArray()) {
            if (enableSingleCharWildcard && c == '?' || c == '*') {
                builder.append(GlobPattern.quotePrecedingLiteralsAndReset(precedingCharactersToQuote));
                builder.append("[^").append(Pattern.quote(new String(boundaries))).append("]");
                if (c != '*') continue;
                builder.append('*');
                continue;
            }
            precedingCharactersToQuote.append(c);
        }
        return Pattern.compile(builder.append(GlobPattern.quotePrecedingLiteralsAndReset(precedingCharactersToQuote)).append('$').toString());
    }

    private static String quotePrecedingLiteralsAndReset(StringBuilder literals) {
        if (literals.length() > 0) {
            String quoted = literals.toString();
            literals.setLength(0);
            return Pattern.quote(quoted);
        }
        return "";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GlobPattern that = (GlobPattern)o;
        return Objects.equals(this.pattern, that.pattern) && Arrays.equals(this.boundaries, that.boundaries);
    }

    public int hashCode() {
        int result = Objects.hash(this.pattern);
        result = 31 * result + Arrays.hashCode(this.boundaries);
        return result;
    }

    public String toString() {
        return "GlobPattern{pattern='" + this.pattern + "', boundaries=" + Arrays.toString(this.boundaries) + ", regexPattern=" + this.regexPattern + "}";
    }
}

