/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security.tls.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.security.tls.TransportSecurityOptions;
import com.yahoo.security.tls.json.TransportSecurityOptionsEntity;
import com.yahoo.security.tls.policy.AuthorizedPeers;
import com.yahoo.security.tls.policy.CapabilitySet;
import com.yahoo.security.tls.policy.PeerPolicy;
import com.yahoo.security.tls.policy.RequiredPeerCredential;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class TransportSecurityOptionsJsonSerializer {
    private static final ObjectMapper mapper = new ObjectMapper();

    public TransportSecurityOptions deserialize(InputStream in) {
        try {
            TransportSecurityOptionsEntity entity = (TransportSecurityOptionsEntity)mapper.readValue(in, TransportSecurityOptionsEntity.class);
            return TransportSecurityOptionsJsonSerializer.toTransportSecurityOptions(entity);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void serialize(OutputStream out, TransportSecurityOptions options) {
        try {
            mapper.writerWithDefaultPrettyPrinter().writeValue(out, (Object)TransportSecurityOptionsJsonSerializer.toTransportSecurityOptionsEntity(options));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static TransportSecurityOptions toTransportSecurityOptions(TransportSecurityOptionsEntity entity) {
        List<TransportSecurityOptionsEntity.AuthorizedPeer> authorizedPeersEntity;
        TransportSecurityOptions.Builder builder = new TransportSecurityOptions.Builder();
        TransportSecurityOptionsEntity.Files files = entity.files;
        if (files != null) {
            if (files.certificatesFile != null && files.privateKeyFile != null) {
                builder.withCertificates(Paths.get(files.certificatesFile, new String[0]), Paths.get(files.privateKeyFile, new String[0]));
            } else if (files.certificatesFile != null || files.privateKeyFile != null) {
                throw new IllegalArgumentException("Both 'private-key' and 'certificates' must be configured together");
            }
            if (files.caCertificatesFile != null) {
                builder.withCaCertificates(Paths.get(files.caCertificatesFile, new String[0]));
            }
        }
        if ((authorizedPeersEntity = entity.authorizedPeers) != null) {
            if (authorizedPeersEntity.size() == 0) {
                throw new IllegalArgumentException("'authorized-peers' cannot be empty");
            }
            builder.withAuthorizedPeers(new AuthorizedPeers(TransportSecurityOptionsJsonSerializer.toPeerPolicies(authorizedPeersEntity)));
        }
        if (entity.acceptedCiphers != null) {
            if (entity.acceptedCiphers.isEmpty()) {
                throw new IllegalArgumentException("'accepted-ciphers' cannot be empty");
            }
            builder.withAcceptedCiphers(entity.acceptedCiphers);
        }
        if (entity.acceptedProtocols != null) {
            if (entity.acceptedProtocols.isEmpty()) {
                throw new IllegalArgumentException("'accepted-protocols' cannot be empty");
            }
            builder.withAcceptedProtocols(entity.acceptedProtocols);
        }
        if (entity.isHostnameValidationDisabled != null) {
            builder.withHostnameValidationDisabled(entity.isHostnameValidationDisabled);
        }
        return builder.build();
    }

    private static Set<PeerPolicy> toPeerPolicies(List<TransportSecurityOptionsEntity.AuthorizedPeer> authorizedPeersEntity) {
        return authorizedPeersEntity.stream().map(TransportSecurityOptionsJsonSerializer::toPeerPolicy).collect(Collectors.toSet());
    }

    private static PeerPolicy toPeerPolicy(TransportSecurityOptionsEntity.AuthorizedPeer authorizedPeer) {
        if (authorizedPeer.name == null) {
            throw TransportSecurityOptionsJsonSerializer.missingFieldException("name");
        }
        if (authorizedPeer.requiredCredentials == null) {
            throw TransportSecurityOptionsJsonSerializer.missingFieldException("required-credentials");
        }
        return new PeerPolicy(authorizedPeer.name, Optional.ofNullable(authorizedPeer.description), TransportSecurityOptionsJsonSerializer.toCapabilities(authorizedPeer.capabilities), TransportSecurityOptionsJsonSerializer.toRequestPeerCredentials(authorizedPeer.requiredCredentials));
    }

    private static CapabilitySet toCapabilities(List<String> capabilities) {
        if (capabilities == null) {
            return CapabilitySet.all();
        }
        if (capabilities.isEmpty()) {
            throw new IllegalArgumentException("\"capabilities\" array must either be not present (implies all capabilities) or contain at least one capability name");
        }
        return CapabilitySet.fromNames(capabilities);
    }

    private static List<RequiredPeerCredential> toRequestPeerCredentials(List<TransportSecurityOptionsEntity.RequiredCredential> requiredCredentials) {
        return requiredCredentials.stream().map(TransportSecurityOptionsJsonSerializer::toRequiredPeerCredential).collect(Collectors.toList());
    }

    private static RequiredPeerCredential toRequiredPeerCredential(TransportSecurityOptionsEntity.RequiredCredential requiredCredential) {
        if (requiredCredential.field == null) {
            throw TransportSecurityOptionsJsonSerializer.missingFieldException("field");
        }
        if (requiredCredential.matchExpression == null) {
            throw TransportSecurityOptionsJsonSerializer.missingFieldException("must-match");
        }
        return RequiredPeerCredential.of(TransportSecurityOptionsJsonSerializer.toField(requiredCredential.field), requiredCredential.matchExpression);
    }

    private static RequiredPeerCredential.Field toField(TransportSecurityOptionsEntity.CredentialField field) {
        switch (field) {
            case CN: {
                return RequiredPeerCredential.Field.CN;
            }
            case SAN_DNS: {
                return RequiredPeerCredential.Field.SAN_DNS;
            }
            case SAN_URI: {
                return RequiredPeerCredential.Field.SAN_URI;
            }
        }
        throw new IllegalArgumentException("Invalid field type: " + field);
    }

    private static TransportSecurityOptionsEntity toTransportSecurityOptionsEntity(TransportSecurityOptions options) {
        TransportSecurityOptionsEntity entity = new TransportSecurityOptionsEntity();
        entity.files = new TransportSecurityOptionsEntity.Files();
        options.getCaCertificatesFile().ifPresent(value -> {
            entity.files.caCertificatesFile = value.toString();
        });
        options.getCertificatesFile().ifPresent(value -> {
            entity.files.certificatesFile = value.toString();
        });
        options.getPrivateKeyFile().ifPresent(value -> {
            entity.files.privateKeyFile = value.toString();
        });
        entity.authorizedPeers = options.getAuthorizedPeers().peerPolicies().stream().sorted(Comparator.comparing(PeerPolicy::policyName)).map(peerPolicy -> {
            TransportSecurityOptionsEntity.AuthorizedPeer authorizedPeer = new TransportSecurityOptionsEntity.AuthorizedPeer();
            authorizedPeer.name = peerPolicy.policyName();
            authorizedPeer.requiredCredentials = new ArrayList<TransportSecurityOptionsEntity.RequiredCredential>();
            authorizedPeer.description = peerPolicy.description().orElse(null);
            CapabilitySet caps = peerPolicy.capabilities();
            if (!caps.hasAll()) {
                authorizedPeer.capabilities = List.copyOf(caps.toNames());
            }
            for (RequiredPeerCredential requiredPeerCredential : peerPolicy.requiredCredentials()) {
                TransportSecurityOptionsEntity.RequiredCredential requiredCredential = new TransportSecurityOptionsEntity.RequiredCredential();
                requiredCredential.field = TransportSecurityOptionsJsonSerializer.toField(requiredPeerCredential.field());
                requiredCredential.matchExpression = requiredPeerCredential.pattern().asString();
                authorizedPeer.requiredCredentials.add(requiredCredential);
            }
            return authorizedPeer;
        }).toList();
        if (!options.getAcceptedCiphers().isEmpty()) {
            entity.acceptedCiphers = options.getAcceptedCiphers();
        }
        if (!options.getAcceptedProtocols().isEmpty()) {
            entity.acceptedProtocols = options.getAcceptedProtocols();
        }
        if (options.isHostnameValidationDisabled()) {
            entity.isHostnameValidationDisabled = true;
        }
        return entity;
    }

    private static TransportSecurityOptionsEntity.CredentialField toField(RequiredPeerCredential.Field field) {
        switch (field) {
            case CN: {
                return TransportSecurityOptionsEntity.CredentialField.CN;
            }
            case SAN_DNS: {
                return TransportSecurityOptionsEntity.CredentialField.SAN_DNS;
            }
            case SAN_URI: {
                return TransportSecurityOptionsEntity.CredentialField.SAN_URI;
            }
        }
        throw new IllegalArgumentException("Invalid field type: " + field);
    }

    private static IllegalArgumentException missingFieldException(String fieldName) {
        return new IllegalArgumentException(String.format("'%s' missing", fieldName));
    }
}

