/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security.token;

import com.yahoo.security.ArrayUtils;
import com.yahoo.security.token.Token;
import java.util.Arrays;

public record TokenCheckHash(byte[] hashBytes) {
    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenCheckHash tokenCheckHash = (TokenCheckHash)o;
        return Arrays.equals(this.hashBytes, tokenCheckHash.hashBytes);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.hashBytes);
    }

    public String toHexString() {
        return ArrayUtils.hex(this.hashBytes);
    }

    @Override
    public String toString() {
        return this.toHexString();
    }

    public static TokenCheckHash of(Token token, int nHashBytes) {
        return new TokenCheckHash(token.toDerivedBytes(nHashBytes, token.domain().checkHashContext()));
    }

    public static TokenCheckHash ofRawBytes(byte[] hashBytes) {
        return new TokenCheckHash(Arrays.copyOf(hashBytes, hashBytes.length));
    }

    public static TokenCheckHash ofHex(String hex) {
        return TokenCheckHash.ofRawBytes(ArrayUtils.unhex(hex));
    }
}

