/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security;

import com.yahoo.security.AeadCipher;
import com.yahoo.security.SealedSharedKey;
import com.yahoo.security.SharedKeyGenerator;
import javax.crypto.SecretKey;

public record SecretSharedKey(SecretKey secretKey, SealedSharedKey sealedSharedKey) {
    @Override
    public String toString() {
        return "SharedSecretKey(sealed: %s)".formatted(this.sealedSharedKey.toTokenString());
    }

    public AeadCipher makeEncryptionCipher() {
        int version = this.sealedSharedKey.tokenVersion();
        return switch (version) {
            case 1 -> SharedKeyGenerator.makeAesGcmEncryptionCipher(this);
            case 2 -> SharedKeyGenerator.makeChaCha20Poly1305EncryptionCipher(this);
            default -> throw new IllegalStateException("Unsupported token version: " + version);
        };
    }

    public AeadCipher makeDecryptionCipher() {
        int version = this.sealedSharedKey.tokenVersion();
        return switch (version) {
            case 1 -> SharedKeyGenerator.makeAesGcmDecryptionCipher(this);
            case 2 -> SharedKeyGenerator.makeChaCha20Poly1305DecryptionCipher(this);
            default -> throw new IllegalStateException("Unsupported token version: " + version);
        };
    }
}

