/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security;

import com.yahoo.security.BouncyCastleProviderHolder;
import com.yahoo.security.Extension;
import com.yahoo.security.KeyAlgorithm;
import com.yahoo.security.KeyUtils;
import com.yahoo.security.SignatureAlgorithm;
import com.yahoo.security.SignatureUtils;
import com.yahoo.security.SubjectAlternativeName;
import com.yahoo.security.X509CertificateBuilder;
import com.yahoo.security.X509CertificateWithKey;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.naming.NamingException;
import javax.naming.ldap.LdapName;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;

public class X509CertificateUtils {
    private X509CertificateUtils() {
    }

    public static X509Certificate fromPem(String pem) {
        X509Certificate x509Certificate;
        PEMParser parser = new PEMParser((Reader)new StringReader(pem));
        try {
            x509Certificate = X509CertificateUtils.toX509Certificate(parser.readObject());
        }
        catch (Throwable throwable) {
            try {
                try {
                    parser.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            catch (CertificateException e) {
                throw new RuntimeException(e);
            }
        }
        parser.close();
        return x509Certificate;
    }

    public static List<X509Certificate> certificateListFromPem(String pem) {
        ArrayList<X509Certificate> arrayList;
        PEMParser parser = new PEMParser((Reader)new StringReader(pem));
        try {
            Object pemObject;
            ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
            while ((pemObject = parser.readObject()) != null) {
                list.add(X509CertificateUtils.toX509Certificate(pemObject));
            }
            arrayList = list;
        }
        catch (Throwable throwable) {
            try {
                try {
                    parser.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            catch (CertificateException e) {
                throw new RuntimeException(e);
            }
        }
        parser.close();
        return arrayList;
    }

    private static X509Certificate toX509Certificate(Object pemObject) throws CertificateException {
        if (pemObject instanceof X509Certificate) {
            return (X509Certificate)pemObject;
        }
        if (pemObject instanceof X509CertificateHolder) {
            return new JcaX509CertificateConverter().setProvider((Provider)BouncyCastleProviderHolder.getInstance()).getCertificate((X509CertificateHolder)pemObject);
        }
        throw new IllegalArgumentException("Invalid type of PEM object: " + pemObject);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String toPem(X509Certificate certificate) {
        try (StringWriter stringWriter = new StringWriter();){
            String string;
            try (JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)stringWriter);){
                pemWriter.writeObject((PemObjectGenerator)new PemObject("CERTIFICATE", certificate.getEncoded()));
                pemWriter.flush();
                string = stringWriter.toString();
            }
            return string;
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String toPem(List<X509Certificate> certificates) {
        try (StringWriter stringWriter = new StringWriter();){
            String string;
            try (JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)stringWriter);){
                for (X509Certificate certificate : certificates) {
                    pemWriter.writeObject((PemObjectGenerator)new PemObject("CERTIFICATE", certificate.getEncoded()));
                }
                pemWriter.flush();
                string = stringWriter.toString();
            }
            return string;
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static List<String> getSubjectCommonNames(X509Certificate certificate) {
        return X509CertificateUtils.getCommonNames(certificate.getSubjectX500Principal());
    }

    public static Optional<String> getSubjectCommonName(X509Certificate c) {
        List<String> names = X509CertificateUtils.getSubjectCommonNames(c);
        if (names.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(names.get(names.size() - 1));
    }

    public static List<String> getIssuerCommonNames(X509Certificate certificate) {
        return X509CertificateUtils.getCommonNames(certificate.getIssuerX500Principal());
    }

    public static List<String> getSubjectOrganizationalUnits(X509Certificate certificate) {
        return X509CertificateUtils.getRdns(certificate.getSubjectX500Principal(), "OU");
    }

    public static List<String> getCommonNames(X500Principal distinguishedName) {
        return X509CertificateUtils.getRdns(distinguishedName, "CN");
    }

    private static List<String> getRdns(X500Principal distinguishedName, String rdnName) {
        try {
            return new LdapName(distinguishedName.getName()).getRdns().stream().filter(rdn -> rdn.getType().equalsIgnoreCase(rdnName)).map(rdn -> rdn.getValue().toString()).toList();
        }
        catch (NamingException e) {
            throw new IllegalArgumentException("Invalid DN: " + distinguishedName.getName(), e);
        }
    }

    public static List<SubjectAlternativeName> getSubjectAlternativeNames(X509Certificate certificate) {
        try {
            byte[] extensionValue = certificate.getExtensionValue(Extension.SUBJECT_ALTERNATIVE_NAMES.getOId());
            if (extensionValue == null) {
                return Collections.emptyList();
            }
            ASN1Primitive asn1Encodable = ASN1Primitive.fromByteArray((byte[])extensionValue);
            if (asn1Encodable instanceof ASN1OctetString) {
                asn1Encodable = ASN1Primitive.fromByteArray((byte[])((ASN1OctetString)asn1Encodable).getOctets());
            }
            GeneralNames names = GeneralNames.getInstance((Object)asn1Encodable);
            return SubjectAlternativeName.fromGeneralNames(names);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static boolean privateKeyMatchesPublicKey(PrivateKey privateKey, PublicKey publicKey) {
        byte[] someRandomData = new byte[64];
        new Random().nextBytes(someRandomData);
        Signature signer = SignatureUtils.createSigner(privateKey);
        Signature verifier = SignatureUtils.createVerifier(publicKey);
        try {
            signer.update(someRandomData);
            verifier.update(someRandomData);
            byte[] signature = signer.sign();
            return verifier.verify(signature);
        }
        catch (SignatureException e) {
            throw new RuntimeException(e);
        }
    }

    public static X509CertificateWithKey createSelfSigned(String cn, Duration duration) {
        KeyPair keyPair = KeyUtils.generateKeypair(KeyAlgorithm.EC, 256);
        X500Principal subject = new X500Principal(cn);
        Instant now = Instant.now();
        X509Certificate cert = X509CertificateBuilder.fromKeypair(keyPair, subject, now, now.plus(duration), SignatureAlgorithm.SHA256_WITH_ECDSA, BigInteger.ONE).setBasicConstraints(true, true).build();
        return new X509CertificateWithKey(cert, keyPair.getPrivate());
    }

    public static byte[] getX509CertificateFingerPrint(X509Certificate certificate) {
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
            return sha1.digest(certificate.getEncoded());
        }
        catch (NoSuchAlgorithmException | CertificateEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

