/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security.tls;

import com.yahoo.security.SubjectAlternativeName;
import com.yahoo.security.X509CertificateUtils;
import com.yahoo.security.tls.CapabilityMode;
import com.yahoo.security.tls.CapabilitySet;
import com.yahoo.security.tls.MissingCapabilitiesException;
import com.yahoo.security.tls.TlsMetrics;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;

public record ConnectionAuthContext(List<X509Certificate> peerCertificateChain, CapabilitySet capabilities, Set<String> matchedPolicies, CapabilityMode capabilityMode) {
    private static final Logger log = Logger.getLogger(ConnectionAuthContext.class.getName());

    public ConnectionAuthContext {
        peerCertificateChain = List.copyOf(peerCertificateChain);
        matchedPolicies = Set.copyOf(matchedPolicies);
    }

    private ConnectionAuthContext(List<X509Certificate> certs, CapabilityMode capabilityMode) {
        this(certs, CapabilitySet.all(), Set.of(), capabilityMode);
    }

    public boolean authorized() {
        return !this.capabilities.hasNone();
    }

    public void verifyCapabilities(CapabilitySet requiredCapabilities) throws MissingCapabilitiesException {
        this.verifyCapabilities(requiredCapabilities, null, null, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void verifyCapabilities(CapabilitySet requiredCapabilities, String action, String resource, String peer) throws MissingCapabilitiesException {
        if (this.capabilityMode == CapabilityMode.DISABLE) {
            return;
        }
        boolean hasCapabilities = this.capabilities.has(requiredCapabilities);
        if (hasCapabilities) {
            TlsMetrics.instance().incrementCapabilitiesSucceeded();
            return;
        }
        TlsMetrics.instance().incrementCapabilitiesFailed();
        String msg = this.createPermissionDeniedErrorMessage(requiredCapabilities, action, resource, peer);
        if (this.capabilityMode == CapabilityMode.LOG_ONLY) {
            log.info(msg);
            return;
        }
        log.fine(msg);
        throw new MissingCapabilitiesException(msg);
    }

    String createPermissionDeniedErrorMessage(CapabilitySet required, String action, String resource, String peer) {
        StringBuilder b = new StringBuilder();
        if (this.capabilityMode == CapabilityMode.LOG_ONLY) {
            b.append("Dry-run: ");
        }
        b.append("Permission denied");
        if (resource != null) {
            b.append(" for '");
            if (action != null) {
                b.append(action).append("' on '");
            }
            b.append(resource).append("'");
        }
        b.append(". Peer ");
        if (peer != null) {
            b.append("'").append(peer).append("' ");
        }
        return b.append("with ").append(this.peerCertificateString().orElse("<missing-certificate>")).append(". Requires capabilities ").append(required.toNames()).append(" but peer has ").append(this.capabilities.toNames()).append(".").toString();
    }

    public Optional<X509Certificate> peerCertificate() {
        return this.peerCertificateChain.isEmpty() ? Optional.empty() : Optional.of(this.peerCertificateChain.get(0));
    }

    public Optional<String> peerCertificateString() {
        List<String> uris;
        List<SubjectAlternativeName> sans;
        List<String> dnsNames;
        X509Certificate cert = this.peerCertificate().orElse(null);
        if (cert == null) {
            return Optional.empty();
        }
        StringBuilder b = new StringBuilder("[");
        String cn = X509CertificateUtils.getSubjectCommonName(cert).orElse(null);
        if (cn != null) {
            b.append("CN='").append(cn).append("'");
        }
        if (!(dnsNames = (sans = X509CertificateUtils.getSubjectAlternativeNames(cert)).stream().filter(s -> s.getType() == SubjectAlternativeName.Type.DNS).map(SubjectAlternativeName::getValue).toList()).isEmpty()) {
            if (cn != null) {
                b.append(", ");
            }
            b.append("SAN_DNS=").append(dnsNames);
        }
        if (!(uris = sans.stream().filter(s -> s.getType() == SubjectAlternativeName.Type.URI).map(SubjectAlternativeName::getValue).toList()).isEmpty()) {
            if (cn != null || !dnsNames.isEmpty()) {
                b.append(", ");
            }
            b.append("SAN_URI=").append(uris);
        }
        return Optional.of(b.append("]").toString());
    }

    public static ConnectionAuthContext defaultAllCapabilities() {
        return new ConnectionAuthContext(List.of(), CapabilityMode.DISABLE);
    }

    public static ConnectionAuthContext defaultAllCapabilities(List<X509Certificate> certs) {
        return new ConnectionAuthContext(certs, CapabilityMode.DISABLE);
    }
}

