/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security;

import com.yahoo.security.BouncyCastleProviderHolder;
import com.yahoo.security.KeyAlgorithm;
import com.yahoo.security.KeyFormat;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.FixedPointCombMultiplier;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;

public class KeyUtils {
    private KeyUtils() {
    }

    public static KeyPair generateKeypair(KeyAlgorithm algorithm, int keySize) {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance(algorithm.getAlgorithmName(), (Provider)BouncyCastleProviderHolder.getInstance());
            if (keySize != -1) {
                keyGen.initialize(keySize);
            }
            if (algorithm.getSpec().isPresent()) {
                keyGen.initialize(algorithm.getSpec().get());
            }
            return keyGen.genKeyPair();
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static KeyPair generateKeypair(KeyAlgorithm algorithm) {
        return KeyUtils.generateKeypair(algorithm, -1);
    }

    public static PublicKey extractPublicKey(PrivateKey privateKey) {
        String algorithm = privateKey.getAlgorithm();
        try {
            if (algorithm.equals(KeyAlgorithm.RSA.getAlgorithmName())) {
                KeyFactory keyFactory = KeyUtils.createKeyFactory(KeyAlgorithm.RSA);
                RSAPrivateCrtKey rsaPrivateCrtKey = (RSAPrivateCrtKey)privateKey;
                RSAPublicKeySpec keySpec = new RSAPublicKeySpec(rsaPrivateCrtKey.getModulus(), rsaPrivateCrtKey.getPublicExponent());
                return keyFactory.generatePublic(keySpec);
            }
            if (algorithm.equals(KeyAlgorithm.EC.getAlgorithmName())) {
                KeyFactory keyFactory = KeyUtils.createKeyFactory(KeyAlgorithm.EC);
                BCECPrivateKey ecPrivateKey = (BCECPrivateKey)privateKey;
                ECParameterSpec ecParameterSpec = ecPrivateKey.getParameters();
                ECPoint ecPoint = new FixedPointCombMultiplier().multiply(ecParameterSpec.getG(), ecPrivateKey.getD());
                ECPublicKeySpec keySpec = new ECPublicKeySpec(ecPoint, ecParameterSpec);
                return keyFactory.generatePublic((KeySpec)keySpec);
            }
            throw new IllegalArgumentException("Unexpected key algorithm: " + algorithm);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static KeyPair toKeyPair(PrivateKey privateKey) {
        return new KeyPair(KeyUtils.extractPublicKey(privateKey), privateKey);
    }

    public static KeyPair keyPairFromPemEncodedPrivateKey(String pem) {
        return KeyUtils.toKeyPair(KeyUtils.fromPemEncodedPrivateKey(pem));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PrivateKey fromPemEncodedPrivateKey(String pem) {
        try (PEMParser parser = new PEMParser((Reader)new StringReader(pem));){
            Object pemObject;
            ArrayList<Object> unknownObjects = new ArrayList<Object>();
            while ((pemObject = parser.readObject()) != null) {
                if (pemObject instanceof PrivateKeyInfo) {
                    PrivateKeyInfo keyInfo = (PrivateKeyInfo)pemObject;
                    PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyInfo.getEncoded());
                    PrivateKey privateKey = KeyUtils.createKeyFactory(keyInfo.getPrivateKeyAlgorithm()).generatePrivate(keySpec);
                    return privateKey;
                }
                if (pemObject instanceof PEMKeyPair) {
                    PEMKeyPair pemKeypair = (PEMKeyPair)pemObject;
                    PrivateKeyInfo keyInfo = pemKeypair.getPrivateKeyInfo();
                    PrivateKey privateKey = KeyUtils.createKeyFactory(keyInfo.getPrivateKeyAlgorithm()).generatePrivate(new PKCS8EncodedKeySpec(keyInfo.getEncoded()));
                    return privateKey;
                }
                unknownObjects.add(pemObject);
            }
            throw new IllegalArgumentException("Expected a private key, but found " + ((Object)unknownObjects).toString());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PublicKey fromPemEncodedPublicKey(String pem) {
        try (PEMParser parser = new PEMParser((Reader)new StringReader(pem));){
            SubjectPublicKeyInfo keyInfo;
            block12: {
                Object pemObject;
                ArrayList<Object> unknownObjects = new ArrayList<Object>();
                while ((pemObject = parser.readObject()) != null) {
                    if (pemObject instanceof SubjectPublicKeyInfo) {
                        keyInfo = (SubjectPublicKeyInfo)pemObject;
                        break block12;
                    }
                    if (pemObject instanceof PEMKeyPair) {
                        PEMKeyPair pemKeypair = (PEMKeyPair)pemObject;
                        keyInfo = pemKeypair.getPublicKeyInfo();
                        break block12;
                    }
                    unknownObjects.add(pemObject);
                }
                throw new IllegalArgumentException("Expected a public key, but found " + ((Object)unknownObjects).toString());
            }
            PublicKey publicKey = KeyUtils.createKeyFactory(keyInfo.getAlgorithm()).generatePublic(new X509EncodedKeySpec(keyInfo.getEncoded()));
            return publicKey;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toPem(PrivateKey privateKey) {
        return KeyUtils.toPem(privateKey, KeyFormat.PKCS1);
    }

    public static String toPem(PrivateKey privateKey, KeyFormat format) {
        switch (format) {
            case PKCS1: {
                return KeyUtils.toPkcs1Pem(privateKey);
            }
            case PKCS8: {
                return KeyUtils.toPkcs8Pem(privateKey);
            }
        }
        throw new IllegalArgumentException("Unknown format: " + (Object)((Object)format));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String toPem(PublicKey publicKey) {
        try (StringWriter stringWriter = new StringWriter();){
            String string;
            try (JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)stringWriter);){
                pemWriter.writeObject((Object)publicKey);
                pemWriter.flush();
                string = stringWriter.toString();
            }
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static String toPkcs1Pem(PrivateKey privateKey) {
        try (StringWriter stringWriter = new StringWriter();){
            String string;
            try (JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)stringWriter);){
                String type;
                String algorithm = privateKey.getAlgorithm();
                if (algorithm.equals(KeyAlgorithm.RSA.getAlgorithmName())) {
                    type = "RSA PRIVATE KEY";
                } else if (algorithm.equals(KeyAlgorithm.EC.getAlgorithmName())) {
                    type = "EC PRIVATE KEY";
                } else {
                    throw new IllegalArgumentException("Unexpected key algorithm: " + algorithm);
                }
                pemWriter.writeObject((PemObjectGenerator)new PemObject(type, KeyUtils.getPkcs1Bytes(privateKey)));
                pemWriter.flush();
                string = stringWriter.toString();
            }
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static String toPkcs8Pem(PrivateKey privateKey) {
        try (StringWriter stringWriter = new StringWriter();){
            String string;
            try (JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)stringWriter);){
                pemWriter.writeObject((PemObjectGenerator)new PemObject("PRIVATE KEY", privateKey.getEncoded()));
                pemWriter.flush();
                string = stringWriter.toString();
            }
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static byte[] getPkcs1Bytes(PrivateKey privateKey) throws IOException {
        byte[] privBytes = privateKey.getEncoded();
        PrivateKeyInfo pkInfo = PrivateKeyInfo.getInstance((Object)privBytes);
        ASN1Encodable encodable = pkInfo.parsePrivateKey();
        ASN1Primitive primitive = encodable.toASN1Primitive();
        return primitive.getEncoded();
    }

    private static KeyFactory createKeyFactory(AlgorithmIdentifier algorithm) throws NoSuchAlgorithmException {
        if (X9ObjectIdentifiers.id_ecPublicKey.equals((ASN1Primitive)algorithm.getAlgorithm())) {
            return KeyUtils.createKeyFactory(KeyAlgorithm.EC);
        }
        if (PKCSObjectIdentifiers.rsaEncryption.equals((ASN1Primitive)algorithm.getAlgorithm())) {
            return KeyUtils.createKeyFactory(KeyAlgorithm.RSA);
        }
        throw new IllegalArgumentException("Unknown key algorithm: " + algorithm);
    }

    private static KeyFactory createKeyFactory(KeyAlgorithm algorithm) throws NoSuchAlgorithmException {
        return KeyFactory.getInstance(algorithm.getAlgorithmName(), (Provider)BouncyCastleProviderHolder.getInstance());
    }
}

