/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security.tls.authz;

import com.yahoo.security.tls.policy.Role;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class AuthorizationResult {
    private final Set<Role> assumedRoles;
    private final Set<String> matchedPolicies;

    public AuthorizationResult(Set<Role> assumedRoles, Set<String> matchedPolicies) {
        this.assumedRoles = Collections.unmodifiableSet(assumedRoles);
        this.matchedPolicies = Collections.unmodifiableSet(matchedPolicies);
    }

    public Set<Role> assumedRoles() {
        return this.assumedRoles;
    }

    public Set<String> matchedPolicies() {
        return this.matchedPolicies;
    }

    public boolean succeeded() {
        return this.matchedPolicies.size() > 0;
    }

    public String toString() {
        return "AuthorizationResult{assumedRoles=" + this.assumedRoles + ", matchedPolicies=" + this.matchedPolicies + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthorizationResult that = (AuthorizationResult)o;
        return Objects.equals(this.assumedRoles, that.assumedRoles) && Objects.equals(this.matchedPolicies, that.matchedPolicies);
    }

    public int hashCode() {
        return Objects.hash(this.assumedRoles, this.matchedPolicies);
    }
}

