/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security.tls;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;

public interface TlsContext
extends AutoCloseable {
    public static final Set<String> ALLOWED_CIPHER_SUITES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256", "TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_AES_128_GCM_SHA256", "TLS_AES_256_GCM_SHA384", "TLS_CHACHA20_POLY1305_SHA256")));
    public static final Set<String> ALLOWED_PROTOCOLS = Collections.singleton("TLSv1.2");
    public static final String SSL_CONTEXT_VERSION = "TLS";

    public static Set<String> getAllowedCipherSuites(SSLContext context) {
        Object[] supportedCiphers = context.getSupportedSSLParameters().getCipherSuites();
        Set<String> enabledCiphers = Arrays.stream(supportedCiphers).filter(ALLOWED_CIPHER_SUITES::contains).collect(Collectors.toSet());
        if (enabledCiphers.isEmpty()) {
            throw new IllegalArgumentException(String.format("Non of the allowed ciphers are supported (allowed=%s, supported=%s)", ALLOWED_CIPHER_SUITES, Arrays.toString(supportedCiphers)));
        }
        return enabledCiphers;
    }

    public static Set<String> getAllowedProtocols(SSLContext context) {
        Object[] supportedProtocols = context.getSupportedSSLParameters().getProtocols();
        Set<String> enabledProtocols = Arrays.stream(supportedProtocols).filter(ALLOWED_PROTOCOLS::contains).collect(Collectors.toSet());
        if (enabledProtocols.isEmpty()) {
            throw new IllegalArgumentException(String.format("Non of the allowed protocols are supported (allowed=%s, supported=%s)", ALLOWED_PROTOCOLS, Arrays.toString(supportedProtocols)));
        }
        return enabledProtocols;
    }

    public SSLContext context();

    public SSLParameters parameters();

    public SSLEngine createSslEngine();

    public SSLEngine createSslEngine(String var1, int var2);

    @Override
    default public void close() {
    }
}

