/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security;

import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.util.Optional;

public enum KeyAlgorithm {
    RSA("RSA", null),
    EC("EC", new ECGenParameterSpec("prime256v1"));

    final String algorithmName;
    private final AlgorithmParameterSpec spec;

    private KeyAlgorithm(String algorithmName, AlgorithmParameterSpec spec) {
        this.algorithmName = algorithmName;
        this.spec = spec;
    }

    String getAlgorithmName() {
        return this.algorithmName;
    }

    Optional<AlgorithmParameterSpec> getSpec() {
        return Optional.ofNullable(this.spec);
    }
}

