/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security.tls;

import com.yahoo.security.SslContextBuilder;
import com.yahoo.security.tls.AuthorizationMode;
import com.yahoo.security.tls.DefaultTlsContext;
import com.yahoo.security.tls.HostnameVerification;
import com.yahoo.security.tls.MutableX509KeyManager;
import com.yahoo.security.tls.MutableX509TrustManager;
import com.yahoo.security.tls.PeerAuthentication;
import com.yahoo.security.tls.TlsContext;
import com.yahoo.security.tls.TlsManager;
import com.yahoo.security.tls.TransportSecurityOptions;
import com.yahoo.security.tls.authz.PeerAuthorizerTrustManager;
import com.yahoo.security.tls.policy.AuthorizedPeers;
import com.yahoo.security.tls.policy.PeerPolicy;
import com.yahoo.vespa.jdk8compat.Set;
import java.lang.ref.WeakReference;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;

public class ConfigFileBasedTlsContext
implements TlsContext {
    private final TlsContext tlsContext;
    private TlsManager tlsManager;
    private static final Map<Path, WeakReference<TlsManager>> trustManagers = new HashMap<Path, WeakReference<TlsManager>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TlsManager getOrCreateTrustManager(Path tlsOptionsConfigFile) {
        Map<Path, WeakReference<TlsManager>> map = trustManagers;
        synchronized (map) {
            WeakReference<TlsManager> tlsRef = trustManagers.get(tlsOptionsConfigFile);
            TlsManager tlsManager = null;
            if (tlsRef != null) {
                tlsManager = (TlsManager)tlsRef.get();
            }
            if (tlsManager == null) {
                tlsManager = new TlsManager(tlsOptionsConfigFile);
                trustManagers.put(tlsOptionsConfigFile, new WeakReference<TlsManager>(tlsManager));
            }
            tlsManager.addRef();
            return tlsManager;
        }
    }

    public ConfigFileBasedTlsContext(Path tlsOptionsConfigFile, AuthorizationMode mode) {
        this(tlsOptionsConfigFile, mode, PeerAuthentication.NEED);
    }

    public ConfigFileBasedTlsContext(Path tlsOptionsConfigFile, AuthorizationMode mode, PeerAuthentication peerAuthentication) {
        this.tlsManager = ConfigFileBasedTlsContext.getOrCreateTrustManager(tlsOptionsConfigFile);
        this.tlsContext = ConfigFileBasedTlsContext.createDefaultTlsContext(this.tlsManager.getOptions(), mode, this.tlsManager.getTrustManager(), this.tlsManager.getKeyManager(), peerAuthentication);
    }

    @Override
    public SSLContext context() {
        return this.tlsContext.context();
    }

    @Override
    public SSLParameters parameters() {
        return this.tlsContext.parameters();
    }

    @Override
    public SSLEngine createSslEngine() {
        return this.tlsContext.createSslEngine();
    }

    @Override
    public SSLEngine createSslEngine(String peerHost, int peerPort) {
        return this.tlsContext.createSslEngine(peerHost, peerPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Map<Path, WeakReference<TlsManager>> map = trustManagers;
        synchronized (map) {
            int references = this.tlsManager.subRef();
            if (references == 0) {
                this.tlsManager.close();
                trustManagers.remove(this.tlsManager.getTlsConfigFile());
            }
        }
    }

    private static DefaultTlsContext createDefaultTlsContext(TransportSecurityOptions options, AuthorizationMode mode, MutableX509TrustManager mutableTrustManager, MutableX509KeyManager mutableKeyManager, PeerAuthentication peerAuthentication) {
        HostnameVerification hostnameVerification = options.isHostnameValidationDisabled() ? HostnameVerification.DISABLED : HostnameVerification.ENABLED;
        PeerAuthorizerTrustManager authorizerTrustManager = options.getAuthorizedPeers().map(authorizedPeers -> new PeerAuthorizerTrustManager((AuthorizedPeers)authorizedPeers, mode, hostnameVerification, mutableTrustManager)).orElseGet(() -> new PeerAuthorizerTrustManager(new AuthorizedPeers(Set.of(new PeerPolicy[0])), AuthorizationMode.DISABLE, hostnameVerification, mutableTrustManager));
        SSLContext sslContext = new SslContextBuilder().withKeyManager(mutableKeyManager).withTrustManager(authorizerTrustManager).build();
        List<String> acceptedCiphers = options.getAcceptedCiphers();
        HashSet<String> ciphers = acceptedCiphers.isEmpty() ? TlsContext.ALLOWED_CIPHER_SUITES : new HashSet<String>(acceptedCiphers);
        return new DefaultTlsContext(sslContext, ciphers, peerAuthentication);
    }
}

