/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security.tls.https;

import com.yahoo.security.tls.MixedMode;
import com.yahoo.security.tls.TransportSecurityUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

class TlsAwareHttpRequest
extends HttpRequest {
    private final URI rewrittenUri;
    private final HttpRequest wrappedRequest;
    private final HttpHeaders rewrittenHeaders;

    TlsAwareHttpRequest(HttpRequest wrappedRequest, String userAgent) {
        this.wrappedRequest = wrappedRequest;
        this.rewrittenUri = TlsAwareHttpRequest.rewriteUri(wrappedRequest.uri());
        this.rewrittenHeaders = TlsAwareHttpRequest.rewriteHeaders(wrappedRequest, userAgent);
    }

    @Override
    public Optional<HttpRequest.BodyPublisher> bodyPublisher() {
        return this.wrappedRequest.bodyPublisher();
    }

    @Override
    public String method() {
        return this.wrappedRequest.method();
    }

    @Override
    public Optional<Duration> timeout() {
        return this.wrappedRequest.timeout();
    }

    @Override
    public boolean expectContinue() {
        return this.wrappedRequest.expectContinue();
    }

    @Override
    public URI uri() {
        return this.rewrittenUri;
    }

    @Override
    public Optional<HttpClient.Version> version() {
        return this.wrappedRequest.version();
    }

    @Override
    public HttpHeaders headers() {
        return this.rewrittenHeaders;
    }

    private static URI rewriteUri(URI uri) {
        if (!uri.getScheme().equals("http")) {
            return uri;
        }
        String rewrittenScheme = TransportSecurityUtils.getConfigFile().isPresent() && TransportSecurityUtils.getInsecureMixedMode() != MixedMode.PLAINTEXT_CLIENT_MIXED_SERVER ? "https" : "http";
        int port = uri.getPort();
        int rewrittenPort = port != -1 ? port : (rewrittenScheme.equals("http") ? 80 : 443);
        try {
            return new URI(rewrittenScheme, uri.getUserInfo(), uri.getHost(), rewrittenPort, uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static HttpHeaders rewriteHeaders(HttpRequest request, String userAgent) {
        HttpHeaders headers = request.headers();
        if (headers.firstValue("User-Agent").isPresent()) {
            return headers;
        }
        HashMap<String, List<String>> rewrittenHeaders = new HashMap<String, List<String>>(headers.map());
        rewrittenHeaders.put("User-Agent", List.of(userAgent));
        return HttpHeaders.of(rewrittenHeaders, (ignored1, ignored2) -> true);
    }

    public String toString() {
        return "TlsAwareHttpRequest{rewrittenUri=" + this.rewrittenUri + ", wrappedRequest=" + this.wrappedRequest + "}";
    }
}

