/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security.tls.authz;

import com.yahoo.security.SubjectAlternativeName;
import com.yahoo.security.X509CertificateUtils;
import com.yahoo.security.tls.authz.AuthorizationResult;
import com.yahoo.security.tls.policy.AuthorizedPeers;
import com.yahoo.security.tls.policy.PeerPolicy;
import com.yahoo.security.tls.policy.RequiredPeerCredential;
import com.yahoo.security.tls.policy.Role;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class PeerAuthorizer {
    private static final Logger log = Logger.getLogger(PeerAuthorizer.class.getName());
    private final AuthorizedPeers authorizedPeers;

    public PeerAuthorizer(AuthorizedPeers authorizedPeers) {
        this.authorizedPeers = authorizedPeers;
    }

    public AuthorizationResult authorizePeer(X509Certificate peerCertificate) {
        HashSet<Role> assumedRoles = new HashSet<Role>();
        HashSet<String> matchedPolicies = new HashSet<String>();
        String cn = PeerAuthorizer.getCommonName(peerCertificate).orElse(null);
        List<String> sans = PeerAuthorizer.getSubjectAlternativeNames(peerCertificate);
        log.fine(() -> String.format("Subject info from x509 certificate: CN=[%s], 'SAN=%s", cn, sans));
        for (PeerPolicy peerPolicy : this.authorizedPeers.peerPolicies()) {
            if (!PeerAuthorizer.matchesPolicy(peerPolicy, cn, sans)) continue;
            assumedRoles.addAll(peerPolicy.assumedRoles());
            matchedPolicies.add(peerPolicy.policyName());
        }
        return new AuthorizationResult(assumedRoles, matchedPolicies);
    }

    private static boolean matchesPolicy(PeerPolicy peerPolicy, String cn, List<String> sans) {
        return peerPolicy.requiredCredentials().stream().allMatch(requiredCredential -> PeerAuthorizer.matchesRequiredCredentials(requiredCredential, cn, sans));
    }

    private static boolean matchesRequiredCredentials(RequiredPeerCredential requiredCredential, String cn, List<String> sans) {
        switch (requiredCredential.field()) {
            case CN: {
                return cn != null && requiredCredential.pattern().matches(cn);
            }
            case SAN_DNS: {
                return sans.stream().anyMatch(san -> requiredCredential.pattern().matches((String)san));
            }
        }
        throw new RuntimeException("Unknown field: " + requiredCredential.field());
    }

    private static Optional<String> getCommonName(X509Certificate peerCertificate) {
        return X509CertificateUtils.getSubjectCommonNames(peerCertificate).stream().findFirst();
    }

    private static List<String> getSubjectAlternativeNames(X509Certificate peerCertificate) {
        return X509CertificateUtils.getSubjectAlternativeNames(peerCertificate).stream().filter(san -> san.getType() == SubjectAlternativeName.Type.DNS_NAME || san.getType() == SubjectAlternativeName.Type.IP_ADDRESS).map(SubjectAlternativeName::getValue).collect(Collectors.toList());
    }
}

