/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security.tls;

import com.yahoo.security.SslContextBuilder;
import com.yahoo.security.tls.AuthorizationMode;
import com.yahoo.security.tls.PeerAuthentication;
import com.yahoo.security.tls.TlsContext;
import com.yahoo.security.tls.authz.PeerAuthorizerTrustManager;
import com.yahoo.security.tls.policy.AuthorizedPeers;
import com.yahoo.security.tls.policy.PeerPolicy;
import com.yahoo.vespa.jdk8compat.Collection;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;

public class DefaultTlsContext
implements TlsContext {
    private static final Logger log = Logger.getLogger(DefaultTlsContext.class.getName());
    private final SSLContext sslContext;
    private final String[] validCiphers;
    private final String[] validProtocols;
    private final PeerAuthentication peerAuthentication;

    public DefaultTlsContext(List<X509Certificate> certificates, PrivateKey privateKey, List<X509Certificate> caCertificates, AuthorizedPeers authorizedPeers, AuthorizationMode mode, PeerAuthentication peerAuthentication) {
        this(DefaultTlsContext.createSslContext(certificates, privateKey, caCertificates, authorizedPeers, mode), peerAuthentication);
    }

    public DefaultTlsContext(SSLContext sslContext, PeerAuthentication peerAuthentication) {
        this(sslContext, TlsContext.ALLOWED_CIPHER_SUITES, peerAuthentication);
    }

    public DefaultTlsContext(SSLContext sslContext) {
        this(sslContext, TlsContext.ALLOWED_CIPHER_SUITES, PeerAuthentication.NEED);
    }

    DefaultTlsContext(SSLContext sslContext, Set<String> acceptedCiphers, PeerAuthentication peerAuthentication) {
        this.sslContext = sslContext;
        this.peerAuthentication = peerAuthentication;
        this.validCiphers = DefaultTlsContext.getAllowedCiphers(sslContext, acceptedCiphers);
        this.validProtocols = DefaultTlsContext.getAllowedProtocols(sslContext);
    }

    private static String[] getAllowedCiphers(SSLContext sslContext, Set<String> acceptedCiphers) {
        Set<String> supportedCiphers = TlsContext.getAllowedCipherSuites(sslContext);
        String[] allowedCiphers = (String[])supportedCiphers.stream().filter(acceptedCiphers::contains).toArray(String[]::new);
        if (allowedCiphers.length == 0) {
            throw new IllegalStateException(String.format("None of the accepted ciphers are supported (supported=%s, accepted=%s)", supportedCiphers, acceptedCiphers));
        }
        log.log(Level.FINE, () -> String.format("Allowed cipher suites that are supported: %s", com.yahoo.vespa.jdk8compat.List.of(allowedCiphers)));
        return allowedCiphers;
    }

    private static String[] getAllowedProtocols(SSLContext sslContext) {
        Set<String> allowedProtocols = TlsContext.getAllowedProtocols(sslContext);
        log.log(Level.FINE, () -> String.format("Allowed protocols that are supported: %s", com.yahoo.vespa.jdk8compat.List.of(allowedProtocols)));
        return Collection.toArray(allowedProtocols, String[]::new);
    }

    @Override
    public SSLContext context() {
        return this.sslContext;
    }

    @Override
    public SSLParameters parameters() {
        return this.createSslParameters();
    }

    @Override
    public SSLEngine createSslEngine() {
        SSLEngine sslEngine = this.sslContext.createSSLEngine();
        sslEngine.setSSLParameters(this.createSslParameters());
        return sslEngine;
    }

    @Override
    public SSLEngine createSslEngine(String peerHost, int peerPort) {
        SSLEngine sslEngine = this.sslContext.createSSLEngine(peerHost, peerPort);
        sslEngine.setSSLParameters(this.createSslParameters());
        return sslEngine;
    }

    private SSLParameters createSslParameters() {
        SSLParameters newParameters = this.sslContext.getDefaultSSLParameters();
        newParameters.setCipherSuites(this.validCiphers);
        newParameters.setProtocols(this.validProtocols);
        switch (this.peerAuthentication) {
            case WANT: {
                newParameters.setWantClientAuth(true);
                break;
            }
            case NEED: {
                newParameters.setNeedClientAuth(true);
                break;
            }
            case DISABLED: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown peer authentication: " + (Object)((Object)this.peerAuthentication));
            }
        }
        return newParameters;
    }

    private static SSLContext createSslContext(List<X509Certificate> certificates, PrivateKey privateKey, List<X509Certificate> caCertificates, AuthorizedPeers authorizedPeers, AuthorizationMode mode) {
        SslContextBuilder builder = new SslContextBuilder();
        if (!certificates.isEmpty()) {
            builder.withKeyStore(privateKey, certificates);
        }
        if (!caCertificates.isEmpty()) {
            builder.withTrustStore(caCertificates);
        }
        if (authorizedPeers != null) {
            builder.withTrustManagerFactory(truststore -> new PeerAuthorizerTrustManager(authorizedPeers, mode, truststore));
        } else {
            builder.withTrustManagerFactory(truststore -> new PeerAuthorizerTrustManager(new AuthorizedPeers(com.yahoo.vespa.jdk8compat.Set.of(new PeerPolicy[0])), AuthorizationMode.DISABLE, truststore));
        }
        return builder.build();
    }
}

