/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security.tls;

import com.yahoo.security.SslContextBuilder;
import com.yahoo.security.tls.AuthorizationMode;
import com.yahoo.security.tls.PeerAuthentication;
import com.yahoo.security.tls.TlsContext;
import com.yahoo.security.tls.authz.PeerAuthorizerTrustManager;
import com.yahoo.security.tls.policy.AuthorizedPeers;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;

public class DefaultTlsContext
implements TlsContext {
    private static final Logger log = Logger.getLogger(DefaultTlsContext.class.getName());
    private final SSLContext sslContext;
    private final String[] validCiphers;
    private final String[] validProtocols;
    private final PeerAuthentication peerAuthentication;

    public DefaultTlsContext(List<X509Certificate> certificates, PrivateKey privateKey, List<X509Certificate> caCertificates, AuthorizedPeers authorizedPeers, AuthorizationMode mode, PeerAuthentication peerAuthentication) {
        this(DefaultTlsContext.createSslContext(certificates, privateKey, caCertificates, authorizedPeers, mode), peerAuthentication);
    }

    public DefaultTlsContext(SSLContext sslContext, PeerAuthentication peerAuthentication) {
        this(sslContext, TlsContext.ALLOWED_CIPHER_SUITES, peerAuthentication);
    }

    public DefaultTlsContext(SSLContext sslContext) {
        this(sslContext, TlsContext.ALLOWED_CIPHER_SUITES, PeerAuthentication.NEED);
    }

    DefaultTlsContext(SSLContext sslContext, Set<String> acceptedCiphers, PeerAuthentication peerAuthentication) {
        this.sslContext = sslContext;
        this.peerAuthentication = peerAuthentication;
        this.validCiphers = DefaultTlsContext.getAllowedCiphers(sslContext, acceptedCiphers);
        this.validProtocols = DefaultTlsContext.getAllowedProtocols(sslContext);
    }

    private static String[] getAllowedCiphers(SSLContext sslContext, Set<String> acceptedCiphers) {
        String[] supportedCipherSuites = sslContext.getSupportedSSLParameters().getCipherSuites();
        String[] validCipherSuites = (String[])Arrays.stream(supportedCipherSuites).filter(suite -> ALLOWED_CIPHER_SUITES.contains(suite) && acceptedCiphers.contains(suite)).toArray(String[]::new);
        if (validCipherSuites.length == 0) {
            throw new IllegalStateException(String.format("None of the allowed cipher suites are supported (allowed-cipher-suites=%s, supported-cipher-suites=%s, accepted-cipher-suites=%s)", ALLOWED_CIPHER_SUITES, List.of(supportedCipherSuites), acceptedCiphers));
        }
        log.log(Level.FINE, () -> String.format("Allowed cipher suites that are supported: %s", List.of(validCipherSuites)));
        return validCipherSuites;
    }

    private static String[] getAllowedProtocols(SSLContext sslContext) {
        String[] supportedProtocols = sslContext.getSupportedSSLParameters().getProtocols();
        String[] validProtocols = (String[])Arrays.stream(supportedProtocols).filter(ALLOWED_PROTOCOLS::contains).toArray(String[]::new);
        if (validProtocols.length == 0) {
            throw new IllegalArgumentException(String.format("None of the allowed protocols are supported (allowed-protocols=%s, supported-protocols=%s)", ALLOWED_PROTOCOLS, List.of(supportedProtocols)));
        }
        log.log(Level.FINE, () -> String.format("Allowed protocols that are supported: %s", List.of(validProtocols)));
        return validProtocols;
    }

    @Override
    public SSLContext context() {
        return this.sslContext;
    }

    @Override
    public SSLParameters parameters() {
        return this.createSslParameters();
    }

    @Override
    public SSLEngine createSslEngine() {
        SSLEngine sslEngine = this.sslContext.createSSLEngine();
        sslEngine.setSSLParameters(this.createSslParameters());
        return sslEngine;
    }

    @Override
    public SSLEngine createSslEngine(String peerHost, int peerPort) {
        SSLEngine sslEngine = this.sslContext.createSSLEngine(peerHost, peerPort);
        sslEngine.setSSLParameters(this.createSslParameters());
        return sslEngine;
    }

    private SSLParameters createSslParameters() {
        SSLParameters newParameters = this.sslContext.getDefaultSSLParameters();
        newParameters.setCipherSuites(this.validCiphers);
        newParameters.setProtocols(this.validProtocols);
        switch (this.peerAuthentication) {
            case WANT: {
                newParameters.setWantClientAuth(true);
                break;
            }
            case NEED: {
                newParameters.setNeedClientAuth(true);
                break;
            }
            case DISABLED: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown peer authentication: " + this.peerAuthentication);
            }
        }
        return newParameters;
    }

    private static SSLContext createSslContext(List<X509Certificate> certificates, PrivateKey privateKey, List<X509Certificate> caCertificates, AuthorizedPeers authorizedPeers, AuthorizationMode mode) {
        SslContextBuilder builder = new SslContextBuilder();
        if (!certificates.isEmpty()) {
            builder.withKeyStore(privateKey, certificates);
        }
        if (!caCertificates.isEmpty()) {
            builder.withTrustStore(caCertificates);
        }
        if (authorizedPeers != null) {
            builder.withTrustManagerFactory(truststore -> new PeerAuthorizerTrustManager(authorizedPeers, mode, truststore));
        } else {
            builder.withTrustManagerFactory(truststore -> new PeerAuthorizerTrustManager(new AuthorizedPeers(Set.of()), AuthorizationMode.DISABLE, truststore));
        }
        return builder.build();
    }
}

