/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security.tls;

import java.util.Arrays;

public enum AuthorizationMode {
    DISABLE("disable"),
    LOG_ONLY("log-only"),
    ENFORCE("enforce");

    final String configValue;

    private AuthorizationMode(String configValue) {
        this.configValue = configValue;
    }

    public String configValue() {
        return this.configValue;
    }

    static AuthorizationMode fromConfigValue(String configValue) {
        return Arrays.stream(AuthorizationMode.values()).filter(v -> v.configValue.equals(configValue)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown value: " + configValue));
    }
}

