/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security.tls.authz;

import com.yahoo.security.X509CertificateUtils;
import com.yahoo.security.tls.AuthorizationMode;
import com.yahoo.security.tls.authz.AuthorizationResult;
import com.yahoo.security.tls.authz.PeerAuthorizer;
import com.yahoo.security.tls.policy.AuthorizedPeers;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;

public class PeerAuthorizerTrustManager
extends X509ExtendedTrustManager {
    public static final String HANDSHAKE_SESSION_AUTHZ_RESULT_PROPERTY = "vespa.tls.authorization.result";
    private static final Logger log = Logger.getLogger(PeerAuthorizerTrustManager.class.getName());
    private final PeerAuthorizer authorizer;
    private final X509ExtendedTrustManager defaultTrustManager;
    private final AuthorizationMode mode;

    public PeerAuthorizerTrustManager(AuthorizedPeers authorizedPeers, AuthorizationMode mode, X509ExtendedTrustManager defaultTrustManager) {
        this.authorizer = new PeerAuthorizer(authorizedPeers);
        this.mode = mode;
        this.defaultTrustManager = defaultTrustManager;
    }

    public static TrustManager[] wrapTrustManagersFromKeystore(AuthorizedPeers authorizedPeers, AuthorizationMode mode, KeyStore keystore) throws GeneralSecurityException {
        TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        factory.init(keystore);
        return PeerAuthorizerTrustManager.wrapTrustManagers(authorizedPeers, mode, factory.getTrustManagers());
    }

    public static TrustManager[] wrapTrustManagers(AuthorizedPeers authorizedPeers, AuthorizationMode mode, TrustManager[] managers) {
        TrustManager[] wrappedManagers = new TrustManager[managers.length];
        for (int i = 0; i < managers.length; ++i) {
            wrappedManagers[i] = managers[i] instanceof X509ExtendedTrustManager ? new PeerAuthorizerTrustManager(authorizedPeers, mode, (X509ExtendedTrustManager)managers[i]) : managers[i];
        }
        return wrappedManagers;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.defaultTrustManager.checkClientTrusted(chain, authType);
        this.authorizePeer(chain[0], authType, true, null);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.defaultTrustManager.checkServerTrusted(chain, authType);
        this.authorizePeer(chain[0], authType, false, null);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.defaultTrustManager.checkClientTrusted(chain, authType, socket);
        this.authorizePeer(chain[0], authType, true, null);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.defaultTrustManager.checkServerTrusted(chain, authType, socket);
        this.authorizePeer(chain[0], authType, false, null);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine sslEngine) throws CertificateException {
        this.defaultTrustManager.checkClientTrusted(chain, authType, sslEngine);
        this.authorizePeer(chain[0], authType, true, sslEngine);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine sslEngine) throws CertificateException {
        this.defaultTrustManager.checkServerTrusted(chain, authType, sslEngine);
        this.authorizePeer(chain[0], authType, false, sslEngine);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.defaultTrustManager.getAcceptedIssuers();
    }

    private void authorizePeer(X509Certificate certificate, String authType, boolean isVerifyingClient, SSLEngine sslEngine) throws CertificateException {
        if (this.mode == AuthorizationMode.DISABLE) {
            return;
        }
        log.fine(() -> "Verifying certificate: " + PeerAuthorizerTrustManager.createInfoString(certificate, authType, isVerifyingClient));
        AuthorizationResult result = this.authorizer.authorizePeer(certificate);
        if (sslEngine != null) {
            sslEngine.getHandshakeSession().putValue(HANDSHAKE_SESSION_AUTHZ_RESULT_PROPERTY, result);
        }
        if (result.succeeded()) {
            log.fine(() -> String.format("Verification result: %s", result));
        } else {
            String errorMessage = "Authorization failed: " + PeerAuthorizerTrustManager.createInfoString(certificate, authType, isVerifyingClient);
            log.warning(errorMessage);
            if (this.mode == AuthorizationMode.ENFORCE) {
                throw new CertificateException(errorMessage);
            }
        }
    }

    private static String createInfoString(X509Certificate certificate, String authType, boolean isVerifyingClient) {
        return String.format("DN='%s', SANs=%s, authType='%s', isVerifyingClient='%b'", certificate.getSubjectX500Principal(), X509CertificateUtils.getSubjectAlternativeNames(certificate), authType, isVerifyingClient);
    }
}

